/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.pm.NoOpPasswordManagementService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetTokenCipherExecutor;
import org.apereo.cas.pm.PasswordValidator;
import org.apereo.cas.pm.jdbc.JdbcPasswordManagementService;
import org.apereo.cas.pm.ldap.LdapPasswordManagementService;
import org.apereo.cas.pm.rest.RestPasswordManagementService;
import org.apereo.cas.pm.web.flow.InitPasswordChangeAction;
import org.apereo.cas.pm.web.flow.InitPasswordResetAction;
import org.apereo.cas.pm.web.flow.PasswordChangeAction;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowConfigurer;
import org.apereo.cas.pm.web.flow.SendPasswordResetInstructionsAction;
import org.apereo.cas.pm.web.flow.VerifyPasswordResetRequestAction;
import org.apereo.cas.pm.web.flow.VerifySecurityQuestionsAction;
import org.apereo.cas.util.cipher.NoOpCipherExecutor;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

@Configuration(value="passwordManagementConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class PasswordManagementConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="communicationsManager")
    private CommunicationsManager communicationsManager;
    @Autowired
    private FlowBuilderServices flowBuilderServices;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="loginFlowExecutor")
    private FlowExecutor loginFlowExecutor;

    @RefreshScope
    @Bean
    public HandlerAdapter passwordResetHandlerAdapter() {
        FlowHandlerAdapter handler = new FlowHandlerAdapter(){

            public boolean supports(Object handler) {
                return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("pswdreset");
            }
        };
        handler.setFlowExecutor(this.loginFlowExecutor);
        return handler;
    }

    @RefreshScope
    @Bean
    public Action initPasswordChangeAction() {
        return new InitPasswordChangeAction();
    }

    @Autowired
    @RefreshScope
    @Bean
    public Action initPasswordResetAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new InitPasswordResetAction(passwordManagementService);
    }

    @RefreshScope
    @Bean
    public Action passwordChangeAction() {
        return new PasswordChangeAction(this.passwordChangeService());
    }

    @RefreshScope
    @Bean
    public CipherExecutor<Serializable, String> passwordManagementCipherExecutor() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.isEnabled()) {
            return new PasswordResetTokenCipherExecutor(pm.getReset().getSecurity().getEncryptionKey(), pm.getReset().getSecurity().getSigningKey());
        }
        return NoOpCipherExecutor.getInstance();
    }

    @ConditionalOnMissingBean(name={"passwordChangeService"})
    @RefreshScope
    @Bean
    public PasswordManagementService passwordChangeService() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (this.casProperties.getAuthn().getPm().isEnabled()) {
            if (StringUtils.isNotBlank((CharSequence)pm.getLdap().getLdapUrl()) && StringUtils.isNotBlank((CharSequence)pm.getLdap().getBaseDn()) && StringUtils.isNotBlank((CharSequence)pm.getLdap().getUserFilter())) {
                return new LdapPasswordManagementService(this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm());
            }
            if (StringUtils.isNotBlank((CharSequence)pm.getJdbc().getSqlChangePassword()) && StringUtils.isNotBlank((CharSequence)pm.getJdbc().getSqlFindEmail()) && StringUtils.isNotBlank((CharSequence)pm.getJdbc().getUrl()) && StringUtils.isNotBlank((CharSequence)pm.getJdbc().getUser())) {
                return new JdbcPasswordManagementService(this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm(), Beans.newDataSource((AbstractJpaProperties)this.casProperties.getAuthn().getPm().getJdbc()));
            }
            if (StringUtils.isNotBlank((CharSequence)pm.getRest().getEndpointUrlChange()) && StringUtils.isNotBlank((CharSequence)pm.getRest().getEndpointUrlEmail())) {
                return new RestPasswordManagementService(this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), new RestTemplate(), this.casProperties.getAuthn().getPm());
            }
        }
        if (pm.isEnabled()) {
            LOGGER.warn("No backend is configured to handle the account update and password service operations. Verify your settings");
        }
        return new NoOpPasswordManagementService(this.passwordManagementCipherExecutor(), this.casProperties.getServer().getPrefix(), this.casProperties.getAuthn().getPm());
    }

    @Autowired
    @Bean
    public Action sendPasswordResetInstructionsAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new SendPasswordResetInstructionsAction(this.communicationsManager, passwordManagementService);
    }

    @Bean
    public Action verifyPasswordResetRequestAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new VerifyPasswordResetRequestAction(passwordManagementService);
    }

    @Bean
    public Action verifySecurityQuestionsAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
        return new VerifySecurityQuestionsAction(passwordManagementService);
    }

    @ConditionalOnMissingBean(name={"passwordManagementWebflowConfigurer"})
    @RefreshScope
    @Bean
    public CasWebflowConfigurer passwordManagementWebflowConfigurer() {
        return new PasswordManagementWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry);
    }

    @RefreshScope
    @ConditionalOnMissingBean(name={"passwordValidator"})
    @Bean
    public PasswordValidator passwordValidator() {
        return new PasswordValidator();
    }

    @PostConstruct
    public void init() {
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.isEnabled()) {
            if (!this.communicationsManager.isMailSenderDefined()) {
                LOGGER.warn("CAS is unable to send password-reset emails given no settings are defined to account for email servers, etc");
            }
            if (!this.communicationsManager.isSmsSenderDefined()) {
                LOGGER.warn("CAS is unable to send password-reset sms messages given no settings are defined to account for sms providers, etc");
            }
        }
    }
}

