/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.ldap;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.util.LdapUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.ldaptive.pool.PooledConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LdapPasswordManagementService
extends BasePasswordManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordManagementService.class);

    public LdapPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, PasswordManagementProperties passwordManagementProperties) {
        super(cipherExecutor, issuer, passwordManagementProperties);
    }

    @Override
    public String findEmail(String username) {
        try {
            PasswordManagementProperties.Ldap ldap = this.passwordManagementProperties.getLdap();
            SearchFilter filter = Beans.newLdaptiveSearchFilter((String)ldap.getUserFilter(), (String)"user", Arrays.asList(username));
            LOGGER.debug("Constructed LDAP filter [{}] to locate account email", (Object)filter);
            PooledConnectionFactory factory = Beans.newLdaptivePooledConnectionFactory((AbstractLdapProperties)ldap);
            Response response = LdapUtils.executeSearchOperation((ConnectionFactory)factory, (String)ldap.getBaseDn(), (SearchFilter)filter);
            LOGGER.debug("LDAP response to locate account email is [{}]", (Object)response);
            if (LdapUtils.containsResultEntry((Response)response)) {
                LdapEntry entry = ((SearchResult)response.getResult()).getEntry();
                LOGGER.debug("Found LDAP entry [{}] to use for the account email", (Object)entry);
                String attributeName = this.passwordManagementProperties.getReset().getEmailAttribute();
                LdapAttribute attr = entry.getAttribute(attributeName);
                if (attr != null) {
                    String email = attr.getStringValue();
                    LOGGER.debug("Found email address [{}] for user [{}]. Validating...", (Object)email, (Object)username);
                    if (EmailValidator.getInstance().isValid(email)) {
                        LOGGER.debug("Email address [{}] matches a valid email address", (Object)email);
                        return email;
                    }
                    LOGGER.error("Email [{}] is not a valid address", (Object)email);
                } else {
                    LOGGER.error("Could not locate an LDAP attribute [{}] for [{}] and base DN [{}]", new Object[]{attributeName, filter.format(), ldap.getBaseDn()});
                }
                return null;
            }
            LOGGER.error("Could not locate an LDAP entry for [{}] and base DN [{}]", (Object)filter.format(), (Object)ldap.getBaseDn());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    @Audit(action="CHANGE_PASSWORD", actionResolverName="CHANGE_PASSWORD_ACTION_RESOLVER", resourceResolverName="CHANGE_PASSWORD_RESOURCE_RESOLVER")
    public boolean change(Credential credential, PasswordChangeBean bean) {
        Assert.notNull((Object)credential, (String)"Credential cannot be null");
        Assert.notNull((Object)bean, (String)"PasswordChangeBean cannot be null");
        try {
            PasswordManagementProperties.Ldap ldap = this.passwordManagementProperties.getLdap();
            UsernamePasswordCredential c = (UsernamePasswordCredential)credential;
            SearchFilter filter = Beans.newLdaptiveSearchFilter((String)ldap.getUserFilter(), (String)"user", Arrays.asList(c.getId()));
            LOGGER.debug("Constructed LDAP filter [{}] to update account password", (Object)filter);
            PooledConnectionFactory factory = Beans.newLdaptivePooledConnectionFactory((AbstractLdapProperties)ldap);
            Response response = LdapUtils.executeSearchOperation((ConnectionFactory)factory, (String)ldap.getBaseDn(), (SearchFilter)filter);
            LOGGER.debug("LDAP response to update password is [{}]", (Object)response);
            if (LdapUtils.containsResultEntry((Response)response)) {
                String dn = ((SearchResult)response.getResult()).getEntry().getDn();
                LOGGER.debug("Updating account password for [{}]", (Object)dn);
                if (LdapUtils.executePasswordModifyOperation((String)dn, (ConnectionFactory)factory, (String)c.getPassword(), (String)bean.getPassword(), (AbstractLdapProperties.LdapType)this.passwordManagementProperties.getLdap().getType())) {
                    LOGGER.debug("Successfully updated the account password for [{}]", (Object)dn);
                    return true;
                }
                LOGGER.error("Could not update the LDAP entry's password for [{}] and base DN [{}]", (Object)filter.format(), (Object)ldap.getBaseDn());
            } else {
                LOGGER.error("Could not locate an LDAP entry for [{}] and base DN [{}]", (Object)filter.format(), (Object)ldap.getBaseDn());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public Map<String, String> getSecurityQuestions(String username) {
        LinkedHashMap<String, String> set = new LinkedHashMap<String, String>();
        try {
            PasswordManagementProperties.Ldap ldap = this.passwordManagementProperties.getLdap();
            SearchFilter filter = Beans.newLdaptiveSearchFilter((String)ldap.getUserFilter(), (String)"user", Arrays.asList(username));
            LOGGER.debug("Constructed LDAP filter [{}] to locate security questions", (Object)filter);
            PooledConnectionFactory factory = Beans.newLdaptivePooledConnectionFactory((AbstractLdapProperties)ldap);
            Response response = LdapUtils.executeSearchOperation((ConnectionFactory)factory, (String)ldap.getBaseDn(), (SearchFilter)filter);
            LOGGER.debug("LDAP response for security questions [{}]", (Object)response);
            if (LdapUtils.containsResultEntry((Response)response)) {
                LdapEntry entry = ((SearchResult)response.getResult()).getEntry();
                LOGGER.debug("Located LDAP entry [{}] in the response", (Object)entry);
                Map qs = this.passwordManagementProperties.getLdap().getSecurityQuestionsAttributes();
                LOGGER.debug("Security question attributes are defined to be [{}]", (Object)qs);
                qs.forEach((k, v) -> {
                    LdapAttribute q = entry.getAttribute(k);
                    LdapAttribute a = entry.getAttribute(v);
                    if (q != null && a != null && StringUtils.isNotBlank((CharSequence)q.getStringValue()) && StringUtils.isNotBlank((CharSequence)a.getStringValue())) {
                        LOGGER.debug("Added security question [{}]", (Object)q.getStringValue());
                        set.put(q.getStringValue(), a.getStringValue());
                    }
                });
            } else {
                LOGGER.debug("LDAP response did not contain a result for security questions");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return set;
    }
}

