/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import java.util.Arrays;
import org.apereo.cas.pm.PasswordChangeBean;
import org.apereo.cas.web.flow.AbstractCasWebflowConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class PasswordManagementWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public static final String FLOW_ID_PASSWORD_RESET = "pswdreset";
    public static final String FLOW_VAR_ID_PASSWORD = "password";
    private static final String PASSWORD_CHANGE_ACTION = "passwordChangeAction";
    private static final String SEND_PASSWORD_RESET_INSTRUCTIONS_ACTION = "sendInstructions";
    @Autowired
    @Qualifier(value="initPasswordChangeAction")
    private Action passwordChangeAction;

    public PasswordManagementWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry) {
        super(flowBuilderServices, loginFlowDefinitionRegistry);
    }

    protected void doInitialize() throws Exception {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createViewState(flow, "casAuthenticationBlockedView", "casAuthenticationBlockedView");
            this.createViewState(flow, "casBadWorkstationView", "casBadWorkstationView");
            this.createViewState(flow, "casBadHoursView", "casBadHoursView");
            this.createViewState(flow, "casAccountLockedView", "casAccountLockedView");
            this.createViewState(flow, "casAccountDisabledView", "casAccountDisabledView");
            this.createEndState(flow, "casPasswordUpdateSuccess", "casPasswordUpdateSuccessView");
            if (this.casProperties.getAuthn().getPm().isEnabled()) {
                this.configure(flow, "casAccountDisabledView");
                this.configure(flow, "casExpiredPassView");
                this.configurePasswordReset();
            } else {
                this.createViewState(flow, "casAccountDisabledView", "casAccountDisabledView");
                this.createViewState(flow, "casExpiredPassView", "casExpiredPassView");
                this.createViewState(flow, "casMustChangePassView", "casMustChangePassView");
            }
        }
    }

    private void configurePasswordReset() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ViewState state = (ViewState)flow.getState("viewLoginForm");
            this.createTransitionForState((TransitionableState)state, "resetPassword", "casResetPasswordSendInstructionsView");
            ViewState accountInfo = this.createViewState(flow, "casResetPasswordSendInstructionsView", "casResetPasswordSendInstructionsView");
            this.createTransitionForState((TransitionableState)accountInfo, "findAccount", SEND_PASSWORD_RESET_INSTRUCTIONS_ACTION);
            ActionState sendInst = this.createActionState(flow, SEND_PASSWORD_RESET_INSTRUCTIONS_ACTION, new Action[]{this.createEvaluateAction("sendPasswordResetInstructionsAction")});
            this.createTransitionForState((TransitionableState)sendInst, "success", "casResetPasswordSentInstructionsView");
            this.createTransitionForState((TransitionableState)sendInst, "error", accountInfo.getId());
            this.createViewState(flow, "casResetPasswordSentInstructionsView", "casResetPasswordSentInstructionsView");
            Flow pswdFlow = this.buildFlow("classpath:/webflow/pswdreset/pswdreset-webflow.xml", FLOW_ID_PASSWORD_RESET);
            this.createViewState(pswdFlow, "passwordResetErrorView", "casResetPasswordErrorView");
            this.createEndState(pswdFlow, "casPasswordUpdateSuccess", "casPasswordUpdateSuccessView");
            this.configure(pswdFlow, "casMustChangePassView");
            this.loginFlowDefinitionRegistry.registerFlowDefinition((FlowDefinition)pswdFlow);
        }
    }

    private void configure(Flow flow, String id) {
        this.createFlowVariable(flow, FLOW_VAR_ID_PASSWORD, PasswordChangeBean.class);
        BinderConfiguration binder = this.createStateBinderConfiguration(Arrays.asList(FLOW_VAR_ID_PASSWORD, "confirmedPassword"));
        ViewState viewState = this.createViewState(flow, id, id, binder);
        this.createStateModelBinding((TransitionableState)viewState, FLOW_VAR_ID_PASSWORD, PasswordChangeBean.class);
        viewState.getEntryActionList().add(this.passwordChangeAction);
        Transition transition = this.createTransitionForState((TransitionableState)viewState, "submit", PASSWORD_CHANGE_ACTION);
        transition.getAttributes().put("bind", (Object)Boolean.TRUE);
        transition.getAttributes().put("validate", (Object)Boolean.TRUE);
        this.createStateDefaultTransition((TransitionableState)viewState, id);
        ActionState pswChangeAction = this.createActionState(flow, PASSWORD_CHANGE_ACTION, new Action[]{this.createEvaluateAction(PASSWORD_CHANGE_ACTION)});
        pswChangeAction.getTransitionSet().add(this.createTransition("passwordUpdateSuccess", "casPasswordUpdateSuccess"));
        pswChangeAction.getTransitionSet().add(this.createTransition("error", id));
    }
}

