/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.configuration.model.support.redis.RedisTicketRegistryProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.RedisTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRedisTemplate;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration(value="redisTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RedisTicketRegistryConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    @RefreshScope
    public RedisConnectionFactory redisConnectionFactory() {
        RedisTicketRegistryProperties redis = this.casProperties.getTicket().getRegistry().getRedis();
        RedisObjectFactory obj = new RedisObjectFactory();
        return obj.newRedisConnectionFactory((BaseRedisProperties)redis);
    }

    @Bean
    @RefreshScope
    public RedisTemplate<String, Ticket> ticketRedisTemplate() {
        return new TicketRedisTemplate(this.redisConnectionFactory());
    }

    @Bean
    @RefreshScope
    public TicketRegistry ticketRegistry() {
        RedisTicketRegistryProperties redis = this.casProperties.getTicket().getRegistry().getRedis();
        RedisTicketRegistry r = new RedisTicketRegistry(this.ticketRedisTemplate());
        r.setCipherExecutor(Beans.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)redis.getCrypto(), (String)"redis"));
        return r;
    }
}

