/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTicketRegistry
extends AbstractTicketRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisTicketRegistry.class);
    private static final String CAS_TICKET_PREFIX = "CAS_TICKET:";
    @NotNull
    private final RedisTemplate<String, Ticket> client;

    public RedisTicketRegistry(RedisTemplate<String, Ticket> client) {
        this.client = client;
    }

    public long deleteAll() {
        Set redisKeys = this.client.keys((Object)RedisTicketRegistry.getPatternTicketRedisKey());
        int size = redisKeys.size();
        this.client.delete((Collection)redisKeys);
        return size;
    }

    public boolean deleteSingleTicket(String ticketId) {
        try {
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticketId);
            this.client.delete((Object)redisKey);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Ticket not found or is already removed. Failed deleting [{}]", (Object)ticketId, (Object)e);
            return false;
        }
    }

    public void addTicket(Ticket ticket) {
        try {
            LOGGER.debug("Adding ticket [{}]", (Object)ticket);
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticket.getId());
            Ticket encodeTicket = this.encodeTicket(ticket);
            this.client.boundValueOps((Object)redisKey).set((Object)encodeTicket, (long)RedisTicketRegistry.getTimeout(ticket), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("Failed to add [{}]", (Object)ticket);
        }
    }

    public Ticket getTicket(String ticketId) {
        try {
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticketId);
            Ticket t = (Ticket)this.client.boundValueOps((Object)redisKey).get();
            if (t != null) {
                Ticket result = this.decodeTicket(t);
                if (result != null && result.isExpired()) {
                    LOGGER.debug("Ticket [{}] has expired and is now removed from the cache", (Object)result.getId());
                    this.deleteSingleTicket(ticketId);
                    return null;
                }
                return result;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed fetching [{}] ", (Object)ticketId, (Object)e);
        }
        return null;
    }

    public Collection<Ticket> getTickets() {
        return this.client.keys((Object)RedisTicketRegistry.getPatternTicketRedisKey()).stream().map(redisKey -> {
            Ticket ticket = (Ticket)this.client.boundValueOps(redisKey).get();
            if (ticket == null) {
                this.client.delete(redisKey);
                return null;
            }
            return ticket;
        }).filter(Objects::nonNull).map(arg_0 -> ((RedisTicketRegistry)this).decodeTicket(arg_0)).collect(Collectors.toSet());
    }

    public Ticket updateTicket(Ticket ticket) {
        try {
            LOGGER.debug("Updating ticket [{}]", (Object)ticket);
            Ticket encodeTicket = this.encodeTicket(ticket);
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticket.getId());
            this.client.boundValueOps((Object)redisKey).set((Object)encodeTicket, (long)RedisTicketRegistry.getTimeout(ticket), TimeUnit.SECONDS);
            return encodeTicket;
        }
        catch (Exception e) {
            LOGGER.error("Failed to update [{}]", (Object)ticket);
            return null;
        }
    }

    private static int getTimeout(Ticket ticket) {
        int ttl = ticket.getExpirationPolicy().getTimeToLive().intValue();
        if (ttl == 0) {
            return 1;
        }
        return ttl;
    }

    private static String getTicketRedisKey(String ticketId) {
        return CAS_TICKET_PREFIX + ticketId;
    }

    private static String getPatternTicketRedisKey() {
        return "CAS_TICKET:*";
    }
}

