/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.web.AbstractDelegateController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class ProxyController
extends AbstractDelegateController {
    private static final String CONST_PROXY_FAILURE = "cas2ProxyFailureView";
    private static final String CONST_PROXY_SUCCESS = "cas2ProxySuccessView";
    private static final String MODEL_SERVICE_TICKET = "ticket";
    private final CentralAuthenticationService centralAuthenticationService;
    private final ServiceFactory webApplicationServiceFactory;
    @Autowired
    private ApplicationContext context;

    public ProxyController(CentralAuthenticationService centralAuthenticationService, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        String proxyGrantingTicket = request.getParameter("pgt");
        Service targetService = this.getTargetService(request);
        return StringUtils.hasText((String)proxyGrantingTicket) && targetService != null;
    }

    @GetMapping(path={"/proxy"})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        String proxyGrantingTicket = request.getParameter("pgt");
        Service targetService = this.getTargetService(request);
        if (!StringUtils.hasText((String)proxyGrantingTicket) || targetService == null) {
            return this.generateErrorView("INVALID_REQUEST_PROXY", null, request);
        }
        try {
            ProxyTicket proxyTicket = this.centralAuthenticationService.grantProxyTicket(proxyGrantingTicket, targetService);
            return new ModelAndView(CONST_PROXY_SUCCESS, MODEL_SERVICE_TICKET, (Object)proxyTicket);
        }
        catch (AbstractTicketException e) {
            return this.generateErrorView(e.getCode(), new Object[]{proxyGrantingTicket}, request);
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE_PROXY", new Object[]{targetService}, request);
        }
    }

    private Service getTargetService(HttpServletRequest request) {
        return this.webApplicationServiceFactory.createService(request);
    }

    private ModelAndView generateErrorView(String code, Object[] args, HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView(CONST_PROXY_FAILURE);
        modelAndView.addObject("code", (Object)StringEscapeUtils.escapeHtml4((String)code));
        modelAndView.addObject("description", (Object)StringEscapeUtils.escapeHtml4((String)this.context.getMessage(code, args, code, request.getLocale())));
        return modelAndView;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }
}

