/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.ValidationSpecification;
import org.apereo.cas.web.LegacyValidateController;
import org.apereo.cas.web.ProxyController;
import org.apereo.cas.web.ProxyValidateController;
import org.apereo.cas.web.ServiceValidateController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.v3.V3ProxyValidateController;
import org.apereo.cas.web.v3.V3ServiceValidateController;
import org.apereo.cas.web.view.Cas10ResponseView;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.apereo.cas.web.view.Cas30JsonResponseView;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="casValidationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasValidationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ProtocolAttributeEncoder protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3SuccessView")
    private View cas3SuccessView;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private ValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas20ProtocolValidationSpecification")
    private ValidationSpecification cas20ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas10ProtocolValidationSpecification")
    private ValidationSpecification cas10ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="cas2ServiceFailureView")
    private View cas2ServiceFailureView;
    @Autowired
    @Qualifier(value="cas2SuccessView")
    private View cas2SuccessView;
    @Autowired
    @Qualifier(value="cas3ServiceFailureView")
    private View cas3ServiceFailureView;
    @Autowired
    @Qualifier(value="proxy10Handler")
    private ProxyHandler proxy10Handler;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;

    @Bean
    public View cas1ServiceSuccessView() {
        return new Cas10ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
    }

    @Bean
    public View cas1ServiceFailureView() {
        return new Cas10ResponseView(false, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas2ServiceSuccessView"})
    public View cas2ServiceSuccessView() {
        return new Cas20ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.cas2SuccessView);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ServiceJsonView"})
    public View cas3ServiceJsonView() {
        return new Cas30JsonResponseView(true, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.casProperties.getAuthn().isReleaseProtocolAttributes());
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ServiceSuccessView"})
    public View cas3ServiceSuccessView() {
        String authenticationContextAttribute = this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute();
        boolean isReleaseProtocolAttributes = this.casProperties.getAuthn().isReleaseProtocolAttributes();
        return new Cas30ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, authenticationContextAttribute, this.cas3SuccessView, isReleaseProtocolAttributes);
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"v3ServiceValidateController"})
    public V3ServiceValidateController v3ServiceValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        V3ServiceValidateController c = new V3ServiceValidateController();
        c.setValidationSpecification(this.cas20WithoutProxyProtocolValidationSpecification);
        c.setSuccessView(this.cas3ServiceSuccessView());
        c.setFailureView(this.cas3ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"v3ProxyValidateController"})
    public V3ProxyValidateController v3ProxyValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        V3ProxyValidateController c = new V3ProxyValidateController();
        c.setValidationSpecification(this.cas20ProtocolValidationSpecification);
        c.setSuccessView(this.cas3ServiceSuccessView());
        c.setFailureView(this.cas3ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"proxyValidateController"})
    public ProxyValidateController proxyValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        ProxyValidateController c = new ProxyValidateController();
        c.setValidationSpecification(this.cas20ProtocolValidationSpecification);
        c.setSuccessView(this.cas3ServiceSuccessView());
        c.setFailureView(this.cas3ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"legacyValidateController"})
    public LegacyValidateController legacyValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        LegacyValidateController c = new LegacyValidateController();
        c.setValidationSpecification(this.cas10ProtocolValidationSpecification);
        c.setSuccessView(this.cas1ServiceSuccessView());
        c.setFailureView(this.cas1ServiceFailureView());
        c.setProxyHandler(this.proxy10Handler);
        c.setAuthenticationSystemSupport(authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }

    @Bean
    @ConditionalOnMissingBean(name={"proxyController"})
    public ProxyController proxyController() {
        return new ProxyController(this.centralAuthenticationService, this.webApplicationServiceFactory);
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"serviceValidateController"})
    public ServiceValidateController serviceValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        ServiceValidateController c = new ServiceValidateController();
        c.setValidationSpecification(this.cas20WithoutProxyProtocolValidationSpecification);
        c.setSuccessView(this.cas2ServiceSuccessView());
        c.setFailureView(this.cas2ServiceFailureView);
        c.setProxyHandler(this.proxy20Handler);
        c.setAuthenticationSystemSupport(authenticationSystemSupport);
        c.setServicesManager(this.servicesManager);
        c.setCentralAuthenticationService(this.centralAuthenticationService);
        c.setArgumentExtractor(argumentExtractor);
        c.setMultifactorTriggerSelectionStrategy(this.multifactorTriggerSelectionStrategy);
        c.setAuthenticationContextValidator(this.authenticationContextValidator);
        c.setJsonView(this.cas3ServiceJsonView());
        c.setAuthnContextAttribute(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute());
        return c;
    }
}

