/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class Cas30JsonResponseView
extends Cas30ResponseView {
    public Cas30JsonResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, boolean releaseProtocolAttributes) {
        super(successResponse, protocolAttributeEncoder, servicesManager, authenticationContextAttribute, (View)Cas30JsonResponseView.createDelegatedView(), releaseProtocolAttributes);
    }

    private static MappingJackson2JsonView createDelegatedView() {
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        view.setPrettyPrint(true);
        view.setDisableCaching(true);
        view.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).findAndRegisterModules();
        return view;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CasServiceResponse casResponse = new CasServiceResponse();
        try {
            super.prepareMergedOutputModel(model, request, response);
            if (this.getAssertionFrom(model) != null) {
                CasServiceResponseAuthenticationSuccess success = this.createAuthenticationSuccess(model);
                casResponse.setAuthenticationSuccess(success);
            } else {
                CasServiceResponseAuthenticationFailure failure = this.createAuthenticationFailure(model);
                casResponse.setAuthenticationFailure(failure);
            }
        }
        catch (Exception e) {
            CasServiceResponseAuthenticationFailure failure = this.createAuthenticationFailure(model);
            casResponse.setAuthenticationFailure(failure);
        }
        finally {
            HashMap<String, CasServiceResponse> casModel = new HashMap<String, CasServiceResponse>();
            casModel.put("serviceResponse", casResponse);
            model.clear();
            model.putAll(casModel);
            this.setView((View)Cas30JsonResponseView.createDelegatedView());
        }
    }

    private CasServiceResponseAuthenticationFailure createAuthenticationFailure(Map<String, Object> model) {
        CasServiceResponseAuthenticationFailure failure = new CasServiceResponseAuthenticationFailure();
        failure.setCode(this.getErrorCodeFrom(model));
        failure.setDescription(this.getErrorDescriptionFrom(model));
        return failure;
    }

    private CasServiceResponseAuthenticationSuccess createAuthenticationSuccess(Map<String, Object> model) {
        CasServiceResponseAuthenticationSuccess success = new CasServiceResponseAuthenticationSuccess();
        success.setAttributes(this.getModelAttributes(model));
        Principal principal = this.getPrincipal(model);
        success.setUser(principal.getId());
        success.setProxyGrantingTicket(this.getProxyGrantingTicketIou(model));
        Collection chainedAuthentications = this.getChainedAuthentications(model);
        if (chainedAuthentications != null && !chainedAuthentications.isEmpty()) {
            List proxies = chainedAuthentications.stream().map(authn -> authn.getPrincipal().getId()).collect(Collectors.toList());
            success.setProxies(proxies);
        }
        return success;
    }

    private static class CasServiceResponseAuthenticationFailure {
        private String code;
        private String description;

        private CasServiceResponseAuthenticationFailure() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class CasServiceResponseAuthenticationSuccess {
        private String user;
        private String proxyGrantingTicket;
        private List proxies;
        private Map attributes;

        private CasServiceResponseAuthenticationSuccess() {
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getProxyGrantingTicket() {
            return this.proxyGrantingTicket;
        }

        public void setProxyGrantingTicket(String proxyGrantingTicket) {
            this.proxyGrantingTicket = proxyGrantingTicket;
        }

        public List getProxies() {
            return this.proxies;
        }

        public void setProxies(List proxies) {
            this.proxies = proxies;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map attributes) {
            this.attributes = attributes;
        }
    }

    private static class CasServiceResponse {
        private CasServiceResponseAuthenticationFailure authenticationFailure;
        private CasServiceResponseAuthenticationSuccess authenticationSuccess;

        private CasServiceResponse() {
        }

        public CasServiceResponseAuthenticationFailure getAuthenticationFailure() {
            return this.authenticationFailure;
        }

        public void setAuthenticationFailure(CasServiceResponseAuthenticationFailure authenticationFailure) {
            this.authenticationFailure = authenticationFailure;
        }

        public CasServiceResponseAuthenticationSuccess getAuthenticationSuccess() {
            return this.authenticationSuccess;
        }

        public void setAuthenticationSuccess(CasServiceResponseAuthenticationSuccess authenticationSuccess) {
            this.authenticationSuccess = authenticationSuccess;
        }
    }
}

