/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class Cas30ResponseView
extends Cas20ResponseView {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cas30ResponseView.class);
    private final boolean releaseProtocolAttributes;

    public Cas30ResponseView(boolean successResponse, ProtocolAttributeEncoder protocolAttributeEncoder, ServicesManager servicesManager, String authenticationContextAttribute, View view, boolean releaseProtocolAttributes) {
        super(successResponse, protocolAttributeEncoder, servicesManager, authenticationContextAttribute, view);
        this.releaseProtocolAttributes = releaseProtocolAttributes;
    }

    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.prepareMergedOutputModel(model, request, response);
        Service service = super.getServiceFrom(model);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, Object> principalAttributes = this.getCasPrincipalAttributes(model, registeredService);
        attributes.putAll(principalAttributes);
        LOGGER.debug("Processed response principal attributes from the output model to be [{}]", principalAttributes.keySet());
        if (this.releaseProtocolAttributes) {
            LOGGER.debug("CAS is configured to release protocol-level attributes. Processing...");
            Map<String, Object> protocolAttributes = this.getCasProtocolAuthenticationAttributes(model, registeredService);
            attributes.putAll(protocolAttributes);
            LOGGER.debug("Processed response protocol/authentication attributes from the output model to be [{}]", protocolAttributes.keySet());
        }
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributes, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributes, model, registeredService);
        LOGGER.debug("Final collection of attributes for the response are [{}].", attributes.keySet());
        this.putCasResponseAttributesIntoModel(model, attributes, registeredService);
    }

    protected Map<String, Object> getCasProtocolAuthenticationAttributes(Map<String, Object> model, RegisteredService registeredService) {
        HashMap<String, Object> filteredAuthenticationAttributes = new HashMap<String, Object>(this.getAuthenticationAttributes(model));
        filteredAuthenticationAttributes.put("authenticationDate", Collections.singleton(this.getAuthenticationDate(model)));
        filteredAuthenticationAttributes.put("isFromNewLogin", Collections.singleton(this.isAssertionBackedByNewLogin(model)));
        filteredAuthenticationAttributes.put("longTermAuthenticationRequestTokenUsed", Collections.singleton(this.isRememberMeAuthentication(model)));
        String contextProvider = this.getSatisfiedMultifactorAuthenticationProviderId(model);
        if (StringUtils.isNotBlank((CharSequence)contextProvider) && StringUtils.isNotBlank((CharSequence)this.authenticationContextAttribute)) {
            filteredAuthenticationAttributes.put(this.authenticationContextAttribute, Collections.singleton(contextProvider));
        }
        return filteredAuthenticationAttributes;
    }

    protected Map<String, Object> getCasPrincipalAttributes(Map<String, Object> model, RegisteredService registeredService) {
        return super.getPrincipalAttributesAsMultiValuedAttributes(model);
    }

    protected void putCasResponseAttributesIntoModel(Map<String, Object> model, Map<String, Object> attributes, RegisteredService registeredService) {
        LOGGER.debug("Beginning to encode attributes for the response");
        Map encodedAttributes = this.protocolAttributeEncoder.encodeAttributes(attributes, registeredService);
        LOGGER.debug("Encoded attributes for the response are [{}]", (Object)encodedAttributes);
        super.putIntoModel(model, "attributes", (Object)encodedAttributes);
        ArrayList formattedAttributes = new ArrayList(encodedAttributes.size());
        LOGGER.debug("Beginning to format/render attributes for the response");
        encodedAttributes.forEach((k, v) -> {
            Set values = CollectionUtils.toCollection((Object)v);
            values.forEach(value -> {
                String fmt = "<cas:".concat((String)k).concat(">") + StringEscapeUtils.escapeXml10((String)value.toString().trim()) + "</cas:".concat((String)k).concat(">");
                LOGGER.debug("Formatted attribute for the response: [{}]", (Object)fmt);
                formattedAttributes.add(fmt);
            });
        });
        super.putIntoModel(model, "formattedAttributes", formattedAttributes);
    }
}

