/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HttpBasedServiceCredential;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.AbstractTicketValidationException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationContextTicketValidationException;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.UnauthorizedServiceTicketValidationException;
import org.apereo.cas.validation.ValidationAuthorizer;
import org.apereo.cas.validation.ValidationResponseType;
import org.apereo.cas.web.AbstractDelegateController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public abstract class AbstractServiceValidateController
extends AbstractDelegateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceValidateController.class);
    private Set<CasProtocolValidationSpecification> validationSpecifications = new LinkedHashSet<CasProtocolValidationSpecification>();
    private final Set<ValidationAuthorizer> validationAuthorizers;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServicesManager servicesManager;
    private final CentralAuthenticationService centralAuthenticationService;
    private ProxyHandler proxyHandler;
    private final View successView;
    private final View failureView;
    private final ArgumentExtractor argumentExtractor;
    private final MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    private final AuthenticationContextValidator authenticationContextValidator;
    private final View jsonView;
    private final String authnContextAttribute;

    public AbstractServiceValidateController(CasProtocolValidationSpecification validationSpecification, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, CentralAuthenticationService centralAuthenticationService, ProxyHandler proxyHandler, ArgumentExtractor argumentExtractor, MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy, AuthenticationContextValidator authenticationContextValidator, View jsonView, View successView, View failureView, String authnContextAttribute, Set<ValidationAuthorizer> validationAuthorizers) {
        this(CollectionUtils.wrapSet((Object)validationSpecification), authenticationSystemSupport, servicesManager, centralAuthenticationService, proxyHandler, argumentExtractor, multifactorTriggerSelectionStrategy, authenticationContextValidator, jsonView, successView, failureView, authnContextAttribute, validationAuthorizers);
    }

    public AbstractServiceValidateController(Set<CasProtocolValidationSpecification> validationSpecifications, AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, CentralAuthenticationService centralAuthenticationService, ProxyHandler proxyHandler, ArgumentExtractor argumentExtractor, MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy, AuthenticationContextValidator authenticationContextValidator, View jsonView, View successView, View failureView, String authnContextAttribute, Set<ValidationAuthorizer> validationAuthorizers) {
        this.validationSpecifications = validationSpecifications;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.servicesManager = servicesManager;
        this.centralAuthenticationService = centralAuthenticationService;
        this.proxyHandler = proxyHandler;
        this.argumentExtractor = argumentExtractor;
        this.multifactorTriggerSelectionStrategy = multifactorTriggerSelectionStrategy;
        this.authenticationContextValidator = authenticationContextValidator;
        this.jsonView = jsonView;
        this.authnContextAttribute = authnContextAttribute;
        this.successView = successView;
        this.failureView = failureView;
        this.validationAuthorizers = validationAuthorizers;
    }

    protected Credential getServiceCredentialsFromRequest(WebApplicationService service, HttpServletRequest request) {
        String pgtUrl = request.getParameter("pgtUrl");
        if (StringUtils.hasText((String)pgtUrl)) {
            try {
                RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
                AbstractServiceValidateController.verifyRegisteredServiceProperties(registeredService, (Service)service);
                return new HttpBasedServiceCredential(new URL(pgtUrl), registeredService);
            }
            catch (Exception e) {
                LOGGER.error("Error constructing [{}]", (Object)"pgtUrl", (Object)e);
            }
        }
        return null;
    }

    protected Pair<Boolean, Optional<MultifactorAuthenticationProvider>> validateAuthenticationContext(Assertion assertion, HttpServletRequest request) {
        LOGGER.debug("Locating the primary authentication associated with this service request [{}]", (Object)assertion.getService());
        RegisteredService service = this.servicesManager.findServiceBy(assertion.getService());
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)assertion.getService(), (RegisteredService)service);
        Map providers = this.applicationContext.getBeansOfType(MultifactorAuthenticationProvider.class, false, true);
        Authentication authentication = assertion.getPrimaryAuthentication();
        Optional requestedContext = this.multifactorTriggerSelectionStrategy.resolve(providers.values(), request, service, authentication.getPrincipal());
        if (!requestedContext.isPresent()) {
            LOGGER.debug("No particular authentication context is required for this request");
            return Pair.of((Object)Boolean.TRUE, Optional.empty());
        }
        return this.authenticationContextValidator.validate(authentication, (String)requestedContext.get(), service);
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.setRequiredFields(new String[]{"renew"});
    }

    private TicketGrantingTicket handleProxyGrantingTicketDelivery(String serviceTicketId, Credential credential) throws AuthenticationException, AbstractTicketException {
        ServiceTicket serviceTicket = (ServiceTicket)this.centralAuthenticationService.getTicket(serviceTicketId, ServiceTicket.class);
        AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(serviceTicket.getService(), new Credential[]{credential});
        ProxyGrantingTicket proxyGrantingTicketId = this.centralAuthenticationService.createProxyGrantingTicket(serviceTicketId, authenticationResult);
        LOGGER.debug("Generated proxy-granting ticket [{}] off of service ticket [{}] and credential [{}]", new Object[]{proxyGrantingTicketId.getId(), serviceTicketId, credential});
        return proxyGrantingTicketId;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId;
        WebApplicationService service = this.argumentExtractor.extractService(request);
        String string = serviceTicketId = service != null ? service.getArtifactId() : null;
        if (service == null || !StringUtils.hasText((String)serviceTicketId)) {
            LOGGER.debug("Could not identify service and/or service ticket for service: [{}]", (Object)service);
            return this.generateErrorView("INVALID_REQUEST", null, request, service);
        }
        try {
            this.prepareForTicketValidation(request, service, serviceTicketId);
            return this.handleTicketValidation(request, service, serviceTicketId);
        }
        catch (AbstractTicketValidationException e) {
            String code = e.getCode();
            return this.generateErrorView(code, new Object[]{serviceTicketId, e.getOriginalService().getId(), service.getId()}, request, service);
        }
        catch (AbstractTicketException e) {
            return this.generateErrorView(e.getCode(), new Object[]{serviceTicketId}, request, service);
        }
        catch (UnauthorizedProxyingException e) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE_PROXY", new Object[]{service.getId()}, request, service);
        }
        catch (PrincipalException | UnauthorizedServiceException e) {
            return this.generateErrorView("UNAUTHORIZED_SERVICE", null, request, service);
        }
    }

    protected void prepareForTicketValidation(HttpServletRequest request, WebApplicationService service, String serviceTicketId) {
    }

    protected ModelAndView handleTicketValidation(HttpServletRequest request, WebApplicationService service, String serviceTicketId) {
        Assertion assertion;
        TicketGrantingTicket proxyGrantingTicketId = null;
        Credential serviceCredential = this.getServiceCredentialsFromRequest(service, request);
        if (serviceCredential != null) {
            try {
                proxyGrantingTicketId = this.handleProxyGrantingTicketDelivery(serviceTicketId, serviceCredential);
            }
            catch (AuthenticationException e) {
                LOGGER.warn("Failed to authenticate service credential [{}]", (Object)serviceCredential);
                return this.generateErrorView("INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request, service);
            }
            catch (InvalidTicketException e) {
                LOGGER.error("Failed to create proxy granting ticket due to an invalid ticket for [{}]", (Object)serviceCredential, (Object)e);
                return this.generateErrorView(e.getCode(), new Object[]{serviceTicketId}, request, service);
            }
            catch (AbstractTicketException e) {
                LOGGER.error("Failed to create proxy granting ticket for [{}]", (Object)serviceCredential, (Object)e);
                return this.generateErrorView(e.getCode(), new Object[]{serviceCredential.getId()}, request, service);
            }
        }
        if (!this.validateAssertion(request, serviceTicketId, assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, (Service)service), (Service)service)) {
            return this.generateErrorView("INVALID_TICKET", new Object[]{serviceTicketId}, request, service);
        }
        Pair<Boolean, Optional<MultifactorAuthenticationProvider>> ctxResult = this.validateAuthenticationContext(assertion, request);
        if (!((Boolean)ctxResult.getKey()).booleanValue()) {
            throw new UnsatisfiedAuthenticationContextTicketValidationException(assertion.getService());
        }
        String proxyIou = null;
        if (serviceCredential != null && this.proxyHandler.canHandle(serviceCredential)) {
            proxyIou = this.handleProxyIouDelivery(serviceCredential, proxyGrantingTicketId);
            if (StringUtils.isEmpty((Object)proxyIou)) {
                return this.generateErrorView("INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()}, request, service);
            }
        } else {
            LOGGER.debug("No service credentials specified, and/or the proxy handler [{}] cannot handle credentials", (Object)this.proxyHandler.getClass().getSimpleName());
        }
        this.onSuccessfulValidation(serviceTicketId, assertion);
        LOGGER.debug("Successfully validated service ticket [{}] for service [{}]", (Object)serviceTicketId, (Object)service.getId());
        return this.generateSuccessView(assertion, proxyIou, service, request, (Optional)ctxResult.getValue(), proxyGrantingTicketId);
    }

    private String handleProxyIouDelivery(Credential serviceCredential, TicketGrantingTicket proxyGrantingTicketId) {
        return this.proxyHandler.handle(serviceCredential, proxyGrantingTicketId);
    }

    private boolean validateAssertion(HttpServletRequest request, String serviceTicketId, Assertion assertion, Service service) {
        for (CasProtocolValidationSpecification s : this.validationSpecifications) {
            s.reset();
            ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)s, "validationSpecification");
            this.initBinder(request, binder);
            binder.bind((ServletRequest)request);
            if (s.isSatisfiedBy(assertion, request)) continue;
            LOGGER.warn("Service ticket [{}] does not satisfy validation specification.", (Object)serviceTicketId);
            return false;
        }
        this.enforceTicketValidationAuthorizationFor(request, service, assertion);
        return true;
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
    }

    private ModelAndView generateErrorView(String code, Object[] args, HttpServletRequest request, WebApplicationService service) {
        ModelAndView modelAndView = this.getModelAndView(request, false, service);
        String convertedDescription = this.applicationContext.getMessage(code, args, code, request.getLocale());
        modelAndView.addObject("code", (Object)StringEscapeUtils.escapeHtml4((String)code));
        modelAndView.addObject("description", (Object)StringEscapeUtils.escapeHtml4((String)convertedDescription));
        return modelAndView;
    }

    private ModelAndView getModelAndView(HttpServletRequest request, boolean isSuccess, WebApplicationService service) {
        ValidationResponseType type = service != null ? service.getFormat() : ValidationResponseType.XML;
        String format = request.getParameter("format");
        if (!StringUtils.isEmpty((Object)format)) {
            try {
                type = ValidationResponseType.valueOf((String)format.toUpperCase());
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (type == ValidationResponseType.JSON) {
            return new ModelAndView(this.jsonView);
        }
        return new ModelAndView(isSuccess ? this.successView : this.failureView);
    }

    private ModelAndView generateSuccessView(Assertion assertion, String proxyIou, WebApplicationService service, HttpServletRequest request, Optional<MultifactorAuthenticationProvider> contextProvider, TicketGrantingTicket proxyGrantingTicket) {
        ModelAndView modelAndView = this.getModelAndView(request, true, service);
        modelAndView.addObject("assertion", (Object)assertion);
        modelAndView.addObject("service", (Object)service);
        if (StringUtils.hasText((String)proxyIou)) {
            modelAndView.addObject("pgtIou", (Object)proxyIou);
        }
        if (proxyGrantingTicket != null) {
            modelAndView.addObject("proxyGrantingTicket", (Object)proxyGrantingTicket.getId());
        }
        contextProvider.ifPresent(provider -> modelAndView.addObject(this.authnContextAttribute, (Object)provider.getId()));
        Map<String, ?> augmentedModelObjects = this.augmentSuccessViewModelObjects(assertion);
        if (augmentedModelObjects != null) {
            modelAndView.addAllObjects(augmentedModelObjects);
        }
        return modelAndView;
    }

    protected void enforceTicketValidationAuthorizationFor(HttpServletRequest request, Service service, Assertion assertion) {
        for (ValidationAuthorizer a : this.validationAuthorizers) {
            try {
                a.authorize(request, service, assertion);
            }
            catch (Exception e) {
                throw new UnauthorizedServiceTicketValidationException(service);
            }
        }
    }

    protected Map<String, ?> augmentSuccessViewModelObjects(Assertion assertion) {
        return new HashMap(0);
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    private static void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) {
        if (registeredService == null) {
            String msg = String.format("Service [%s] is not found in service registry.", service.getId());
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in service registry.", service.getId());
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    public View getSuccessView() {
        return this.successView;
    }

    public View getFailureView() {
        return this.failureView;
    }

    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    public void addValidationSpecification(CasProtocolValidationSpecification validationSpecification) {
        this.validationSpecifications.add(validationSpecification);
    }
}

