/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationContextValidator;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorTriggerSelectionStrategy;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.web.support.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.ValidationAuthorizer;
import org.apereo.cas.web.LegacyValidateController;
import org.apereo.cas.web.ProxyController;
import org.apereo.cas.web.ProxyValidateController;
import org.apereo.cas.web.ServiceValidateController;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.v3.V3ProxyValidateController;
import org.apereo.cas.web.v3.V3ServiceValidateController;
import org.apereo.cas.web.view.Cas10ResponseView;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.apereo.cas.web.view.Cas30JsonResponseView;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.View;

@Configuration(value="casValidationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasValidationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="casAttributeEncoder")
    private ProtocolAttributeEncoder protocolAttributeEncoder;
    @Autowired
    @Qualifier(value="cas3SuccessView")
    private View cas3SuccessView;
    @Autowired
    @Qualifier(value="authenticationAttributeReleasePolicy")
    private AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;
    @Autowired
    @Qualifier(value="authenticationContextValidator")
    private AuthenticationContextValidator authenticationContextValidator;
    @Autowired
    @Qualifier(value="cas20WithoutProxyProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas20WithoutProxyProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas20ProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas20ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="cas10ProtocolValidationSpecification")
    private CasProtocolValidationSpecification cas10ProtocolValidationSpecification;
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="cas2ServiceFailureView")
    private View cas2ServiceFailureView;
    @Autowired
    @Qualifier(value="cas2SuccessView")
    private View cas2SuccessView;
    @Autowired
    @Qualifier(value="cas3ServiceFailureView")
    private View cas3ServiceFailureView;
    @Autowired
    @Qualifier(value="cas2ProxySuccessView")
    private View cas2ProxySuccessView;
    @Autowired
    @Qualifier(value="cas2ProxyFailureView")
    private View cas2ProxyFailureView;
    @Autowired
    @Qualifier(value="proxy10Handler")
    private ProxyHandler proxy10Handler;
    @Autowired
    @Qualifier(value="proxy20Handler")
    private ProxyHandler proxy20Handler;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultMultifactorTriggerSelectionStrategy")
    private MultifactorTriggerSelectionStrategy multifactorTriggerSelectionStrategy;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private AuthenticationServiceSelectionPlan selectionStrategies;

    @Bean
    @ConditionalOnMissingBean(name={"cas1ServiceSuccessView"})
    public View cas1ServiceSuccessView() {
        return new Cas10ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.authenticationAttributeReleasePolicy);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas1ServiceFailureView"})
    public View cas1ServiceFailureView() {
        return new Cas10ResponseView(false, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.authenticationAttributeReleasePolicy);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas2ServiceSuccessView"})
    public View cas2ServiceSuccessView() {
        return new Cas20ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.cas2SuccessView, this.authenticationAttributeReleasePolicy, this.selectionStrategies);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ServiceJsonView"})
    public View cas3ServiceJsonView() {
        String authenticationContextAttribute = this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute();
        boolean isReleaseProtocolAttributes = this.casProperties.getAuthn().isReleaseProtocolAttributes();
        return new Cas30JsonResponseView(true, this.protocolAttributeEncoder, this.servicesManager, authenticationContextAttribute, isReleaseProtocolAttributes, this.authenticationAttributeReleasePolicy, this.selectionStrategies);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cas3ServiceSuccessView"})
    public View cas3ServiceSuccessView() {
        String authenticationContextAttribute = this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute();
        boolean isReleaseProtocolAttributes = this.casProperties.getAuthn().isReleaseProtocolAttributes();
        return new Cas30ResponseView(true, this.protocolAttributeEncoder, this.servicesManager, authenticationContextAttribute, this.cas3SuccessView, isReleaseProtocolAttributes, this.authenticationAttributeReleasePolicy, this.selectionStrategies);
    }

    @Bean
    @ConditionalOnMissingBean(name={"proxyController"})
    public ProxyController proxyController() {
        return new ProxyController(this.centralAuthenticationService, this.webApplicationServiceFactory, this.cas2ProxySuccessView, this.cas2ProxyFailureView);
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"v3ServiceValidateController"})
    public V3ServiceValidateController v3ServiceValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        return new V3ServiceValidateController(this.cas20WithoutProxyProtocolValidationSpecification, authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy20Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers());
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"v3ProxyValidateController"})
    public V3ProxyValidateController v3ProxyValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        return new V3ProxyValidateController(this.cas20ProtocolValidationSpecification, authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy20Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers());
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"proxyValidateController"})
    public ProxyValidateController proxyValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        if (this.casProperties.getView().getCas2().isV3ForwardCompatible()) {
            return new ProxyValidateController(this.cas20ProtocolValidationSpecification, authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy20Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers());
        }
        return new ProxyValidateController(this.cas20ProtocolValidationSpecification, authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy20Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas2ServiceSuccessView(), this.cas2ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers());
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"legacyValidateController"})
    public LegacyValidateController legacyValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        return new LegacyValidateController(this.cas10ProtocolValidationSpecification, authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy10Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas1ServiceSuccessView(), this.cas1ServiceFailureView(), this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers());
    }

    @Autowired
    @Bean
    @ConditionalOnMissingBean(name={"serviceValidateController"})
    public ServiceValidateController serviceValidateController(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport) {
        if (this.casProperties.getView().getCas2().isV3ForwardCompatible()) {
            return new ServiceValidateController(this.cas20WithoutProxyProtocolValidationSpecification, authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy10Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas3ServiceSuccessView(), this.cas3ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers());
        }
        return new ServiceValidateController(this.cas20WithoutProxyProtocolValidationSpecification, authenticationSystemSupport, this.servicesManager, this.centralAuthenticationService, this.proxy10Handler, argumentExtractor, this.multifactorTriggerSelectionStrategy, this.authenticationContextValidator, this.cas3ServiceJsonView(), this.cas2ServiceSuccessView(), this.cas2ServiceFailureView, this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.serviceValidationAuthorizers());
    }

    @Bean
    @ConditionalOnMissingBean(name={"serviceValidationAuthorizers"})
    public Set<ValidationAuthorizer> serviceValidationAuthorizers() {
        return new LinkedHashSet<ValidationAuthorizer>(0);
    }
}

