/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collections;
import java.util.HashMap;
import javax.servlet.Filter;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.security.HttpWebRequestProperties;
import org.apereo.cas.security.RequestParameterPolicyEnforcementFilter;
import org.apereo.cas.security.ResponseHeadersEnforcementFilter;
import org.apereo.cas.web.support.AuthenticationCredentialsLocalBinderClearingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.CorsFilter;

@Configuration(value="casFiltersConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasFiltersConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public FilterRegistrationBean characterEncodingFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new CharacterEncodingFilter(this.casProperties.getHttpWebRequest().getWeb().getEncoding(), this.casProperties.getHttpWebRequest().getWeb().isForceEncoding()));
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setName("characterEncodingFilter");
        bean.setAsyncSupported(true);
        return bean;
    }

    @ConditionalOnProperty(prefix="cas.httpWebRequest.cors", name={"enabled"}, havingValue="true")
    @Bean
    @RefreshScope
    public FilterRegistrationBean casCorsFilter() {
        HttpWebRequestProperties.Cors cors = this.casProperties.getHttpWebRequest().getCors();
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(cors.isEnabled()));
        config.setAllowedOrigins(cors.getAllowOrigins());
        config.setAllowedMethods(cors.getAllowMethods());
        config.setAllowedHeaders(cors.getAllowHeaders());
        config.setMaxAge(Long.valueOf(cors.getMaxAge()));
        config.setExposedHeaders(cors.getExposedHeaders());
        source.registerCorsConfiguration("/**", config);
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
        bean.setName("casCorsFilter");
        bean.setAsyncSupported(true);
        bean.setOrder(0);
        return bean;
    }

    @RefreshScope
    @Bean
    public FilterRegistrationBean responseHeadersSecurityFilter() {
        HttpWebRequestProperties.Header header = this.casProperties.getHttpWebRequest().getHeader();
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("enableCacheControl", BooleanUtils.toStringTrueFalse((boolean)header.isCache()));
        initParams.put("enableXContentTypeOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXcontent()));
        initParams.put("enableStrictTransportSecurity", BooleanUtils.toStringTrueFalse((boolean)header.isHsts()));
        initParams.put("enableXFrameOptions", BooleanUtils.toStringTrueFalse((boolean)header.isXframe()));
        initParams.put("enableXSSProtection", BooleanUtils.toStringTrueFalse((boolean)header.isXss()));
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ResponseHeadersEnforcementFilter());
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setInitParameters(initParams);
        bean.setName("responseHeadersSecurityFilter");
        bean.setAsyncSupported(true);
        return bean;
    }

    @RefreshScope
    @Bean
    public FilterRegistrationBean requestParameterSecurityFilter() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        initParams.put("parametersToCheck", this.casProperties.getHttpWebRequest().getParamsToCheck());
        initParams.put("charactersToForbid", "none");
        initParams.put("allowMultiValuedParameters", BooleanUtils.toStringTrueFalse((boolean)this.casProperties.getHttpWebRequest().isAllowMultiValueParameters()));
        initParams.put("onlyPostParameters", this.casProperties.getHttpWebRequest().getOnlyPostParams());
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new RequestParameterPolicyEnforcementFilter());
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setName("requestParameterSecurityFilter");
        bean.setInitParameters(initParams);
        bean.setAsyncSupported(true);
        return bean;
    }

    @Bean
    public FilterRegistrationBean currentCredentialsAndAuthenticationClearingFilter() {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new AuthenticationCredentialsLocalBinderClearingFilter());
        bean.setUrlPatterns(Collections.singleton("/*"));
        bean.setName("currentCredentialsAndAuthenticationClearingFilter");
        bean.setAsyncSupported(true);
        return bean;
    }
}

