/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import com.google.common.base.Predicate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.util.spring.boot.AbstractCasBanner;
import org.apereo.cas.util.spring.boot.DefaultCasBanner;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;

public final class CasEmbeddedContainerUtils {
    public static final String EMBEDDED_CONTAINER_CONFIG_ACTIVE = "CasEmbeddedContainerConfigurationActive";
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEmbeddedContainerUtils.class);

    private CasEmbeddedContainerUtils() {
    }

    public static Map<String, Object> getRuntimeProperties(Boolean embeddedContainerActive) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put(EMBEDDED_CONTAINER_CONFIG_ACTIVE, embeddedContainerActive);
        return properties;
    }

    public static Banner getCasBannerInstance() {
        String packageName = CasEmbeddedContainerUtils.class.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true)}));
        Set subTypes = reflections.getSubTypesOf(AbstractCasBanner.class);
        subTypes.remove(DefaultCasBanner.class);
        if (subTypes.isEmpty()) {
            return new DefaultCasBanner();
        }
        try {
            Class clz = (Class)subTypes.iterator().next();
            LOGGER.debug("Created banner [{}]", (Object)clz);
            return (Banner)clz.newInstance();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new DefaultCasBanner();
        }
    }
}

