/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.common.web;

import java.net.Inet4Address;
import javax.servlet.http.HttpServletRequest;

public class ClientInfo {
    public static ClientInfo EMPTY_CLIENT_INFO = new ClientInfo();
    private final String serverIpAddress;
    private final String clientIpAddress;

    private ClientInfo() {
        this(null);
    }

    public ClientInfo(HttpServletRequest request) {
        this(request, null, null, false);
    }

    public ClientInfo(HttpServletRequest request, String alternateServerAddrHeaderName, String alternateLocalAddrHeaderName, boolean useServerHostAddress) {
        try {
            String clientIpAddress;
            String serverIpAddress = request != null ? request.getLocalAddr() : null;
            String string = clientIpAddress = request != null ? request.getRemoteAddr() : null;
            if (request != null) {
                if (useServerHostAddress) {
                    serverIpAddress = Inet4Address.getLocalHost().getHostAddress();
                } else if (alternateServerAddrHeaderName != null && !alternateServerAddrHeaderName.isEmpty()) {
                    String string2 = serverIpAddress = request.getHeader(alternateServerAddrHeaderName) != null ? request.getHeader(alternateServerAddrHeaderName) : request.getLocalAddr();
                }
                if (alternateLocalAddrHeaderName != null && !alternateLocalAddrHeaderName.isEmpty()) {
                    clientIpAddress = request.getHeader(alternateLocalAddrHeaderName) != null ? request.getHeader(alternateLocalAddrHeaderName) : request.getRemoteAddr();
                }
            }
            this.serverIpAddress = serverIpAddress == null ? "unknown" : serverIpAddress;
            this.clientIpAddress = clientIpAddress == null ? "unknown" : clientIpAddress;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }
}

