/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.spring.webflow.plugin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.UUID;
import org.cryptacular.util.CodecUtil;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;

public class ClientFlowExecutionKey
extends FlowExecutionKey {
    public static final String KEY_FORMAT = "<uuid>_<base64-encoded-flow-state>";
    private static final long serialVersionUID = 3514659327458916297L;
    private static final int HASH_SEED = 31;
    private static final int HASH_FACTOR = 99;
    private UUID id;
    private byte[] data;

    public ClientFlowExecutionKey(byte[] data) {
        this(UUID.randomUUID(), data);
    }

    public ClientFlowExecutionKey(UUID id, byte[] data) {
        Assert.notNull((Object)id, (String)"Flow execution id cannot be null.");
        this.id = id;
        this.data = data;
    }

    public UUID getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ClientFlowExecutionKey)) {
            return false;
        }
        ClientFlowExecutionKey other = (ClientFlowExecutionKey)((Object)o);
        return this.id.equals(other.id) && Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int hash = 31;
        hash += 99 * this.id.hashCode();
        for (int i = 0; i < this.data.length; ++i) {
            hash += 99 * this.data[i];
        }
        return hash;
    }

    public String toString() {
        return this.id + "_" + CodecUtil.b64((byte[])this.data);
    }

    public static ClientFlowExecutionKey parse(String key) throws BadlyFormattedFlowExecutionKeyException {
        byte[] decoded;
        UUID uuid;
        String[] tokens = key.split("_");
        if (tokens.length != 2) {
            throw new BadlyFormattedFlowExecutionKeyException(key, KEY_FORMAT);
        }
        try {
            uuid = UUID.fromString(tokens[0]);
        }
        catch (Exception e) {
            throw new BadlyFormattedFlowExecutionKeyException(key, KEY_FORMAT);
        }
        try {
            decoded = CodecUtil.b64((CharSequence)tokens[1]);
        }
        catch (Exception e) {
            throw new BadlyFormattedFlowExecutionKeyException(key, KEY_FORMAT);
        }
        return new ClientFlowExecutionKey(uuid, decoded);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ClientFlowExecutionKey temp = ClientFlowExecutionKey.parse(in.readUTF());
        this.id = temp.id;
        this.data = temp.data;
    }
}

