/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.spring.webflow.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apereo.spring.webflow.plugin.Transcoder;
import org.cryptacular.bean.BufferedBlockCipherBean;
import org.cryptacular.bean.CipherBean;
import org.cryptacular.bean.KeyStoreFactoryBean;
import org.cryptacular.generator.Nonce;
import org.cryptacular.generator.sp80038a.RBGNonce;
import org.cryptacular.io.Resource;
import org.cryptacular.io.URLResource;
import org.cryptacular.spec.BufferedBlockCipherSpec;
import org.cryptacular.spec.Spec;

public class EncryptedTranscoder
implements Transcoder {
    private CipherBean cipherBean;
    private boolean compression = true;

    public EncryptedTranscoder() throws IOException {
        BufferedBlockCipherBean bufferedBlockCipherBean = new BufferedBlockCipherBean();
        bufferedBlockCipherBean.setBlockCipherSpec((Spec)new BufferedBlockCipherSpec("AES", "CBC", "PKCS7"));
        bufferedBlockCipherBean.setKeyStore(this.createAndPrepareKeyStore());
        bufferedBlockCipherBean.setKeyAlias("aes128");
        bufferedBlockCipherBean.setKeyPassword("changeit");
        bufferedBlockCipherBean.setNonce((Nonce)new RBGNonce());
        this.setCipherBean((CipherBean)bufferedBlockCipherBean);
    }

    public EncryptedTranscoder(CipherBean cipherBean) throws IOException {
        this.setCipherBean(cipherBean);
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    protected void setCipherBean(CipherBean cipherBean) {
        this.cipherBean = cipherBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(Object o) throws IOException {
        if (o == null) {
            return new byte[0];
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream out = null;){
            out = this.compression ? new ObjectOutputStream(new GZIPOutputStream(outBuffer)) : new ObjectOutputStream(outBuffer);
            out.writeObject(o);
        }
        try {
            return this.cipherBean.encrypt(outBuffer.toByteArray());
        }
        catch (Exception e) {
            throw new IOException("Encryption error", e);
        }
    }

    @Override
    public Object decode(byte[] encoded) throws IOException {
        byte[] data;
        try {
            data = this.cipherBean.decrypt(encoded);
        }
        catch (Exception e) {
            throw new IOException("Decryption error", e);
        }
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(data);
        try (ObjectInputStream in = null;){
            in = this.compression ? new ObjectInputStream(new GZIPInputStream(inBuffer)) : new ObjectInputStream(inBuffer);
            Object object = in.readObject();
            return object;
        }
    }

    protected KeyStore createAndPrepareKeyStore() {
        KeyStoreFactoryBean ksFactory = new KeyStoreFactoryBean();
        URL u = this.getClass().getResource("/etc/keystore.jceks");
        ksFactory.setResource((Resource)new URLResource(u));
        ksFactory.setType("JCEKS");
        ksFactory.setPassword("changeit");
        return ksFactory.newInstance();
    }
}

