/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.weaver.patterns.DeclareAnnotation;

public class DeclareAnnotationDeclaration
extends DeclareDeclaration {
    private Annotation annotation;
    private boolean isRemover = false;

    public DeclareAnnotationDeclaration(CompilationResult result, DeclareAnnotation symbolicDeclare, Annotation annotation) {
        super(result, symbolicDeclare);
        this.annotation = annotation;
        this.addAnnotation(annotation);
        if (symbolicDeclare == null) {
            return;
        }
        this.isRemover = symbolicDeclare.isRemover();
        symbolicDeclare.setAnnotationString(annotation.toString());
        symbolicDeclare.setAnnotationLocation(annotation.sourceStart, annotation.sourceEnd);
    }

    @Override
    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        long bits;
        super.analyseCode(classScope, flowContext, flowInfo);
        if (this.isRemover) {
            if (((DeclareAnnotation)this.declareDecl).getKind() != DeclareAnnotation.AT_FIELD) {
                classScope.problemReporter().signalError(this.sourceStart(), this.sourceEnd, "Annotation removal only supported for declare @field (compiler limitation)");
            } else if (this.isRemover && !(this.annotation instanceof MarkerAnnotation)) {
                classScope.problemReporter().signalError(this.sourceStart(), this.sourceEnd, "Annotation removal does not allow values to be specified for the annotation (compiler limitation)");
            }
        }
        if (((bits = this.annotation.resolvedType.getAnnotationTagBits()) & 0x800000000L) != 0L) {
            DeclareAnnotation.Kind k = ((DeclareAnnotation)this.declareDecl).getKind();
            if (k.equals(DeclareAnnotation.AT_TYPE) && (bits & 0x4000000000L) != 0L) {
                classScope.problemReporter().disallowedTargetForAnnotation(this.annotation);
            }
            if (k.equals(DeclareAnnotation.AT_FIELD) && (bits & 0x4000000000L) != 0L) {
                classScope.problemReporter().disallowedTargetForAnnotation(this.annotation);
            }
        }
    }

    public Annotation getDeclaredAnnotation() {
        return this.annotation;
    }

    @Override
    protected boolean shouldDelegateCodeGeneration() {
        return true;
    }

    @Override
    protected boolean shouldBeSynthetic() {
        return false;
    }

    private void addAnnotation(Annotation ann) {
        if (this.annotations == null) {
            this.annotations = new Annotation[1];
        } else {
            Annotation[] old = this.annotations;
            this.annotations = new Annotation[old.length + 1];
            System.arraycopy(old, 0, this.annotations, 1, old.length);
        }
        this.annotations[0] = ann;
    }

    @Override
    public void postParse(TypeDeclaration typeDec) {
        super.postParse(typeDec);
        if (this.declareDecl != null) {
            ((DeclareAnnotation)this.declareDecl).setAnnotationMethod(new String(this.selector));
        }
    }

    public boolean isRemover() {
        return this.isRemover;
    }
}

