/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import org.aspectj.org.eclipse.jdt.core.util.ClassFormatException;
import org.aspectj.org.eclipse.jdt.core.util.IConstantPool;
import org.aspectj.org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.aspectj.org.eclipse.jdt.core.util.INestMemberAttributeEntry;
import org.aspectj.org.eclipse.jdt.internal.core.util.ClassFileStruct;

public class NestMembersAttributeEntry
extends ClassFileStruct
implements INestMemberAttributeEntry {
    private int memberClassNameIndex;
    private char[] memberClassName;

    public NestMembersAttributeEntry(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        this.memberClassNameIndex = this.u2At(classFileBytes, 0, offset);
        if (this.memberClassNameIndex != 0) {
            IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.memberClassNameIndex);
            if (constantPoolEntry.getKind() != 7) {
                throw new ClassFormatException(3);
            }
            this.memberClassName = constantPoolEntry.getClassInfoName();
        }
    }

    @Override
    public char[] getNestMemberName() {
        return this.memberClassName;
    }

    @Override
    public int getNestMemberIndex() {
        return this.memberClassNameIndex;
    }

    public String toString() {
        return new String(this.memberClassName);
    }
}

