/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.core;

import javax.swing.JDialog;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.ui.swing.BuildProgressPanel;
import org.aspectj.tools.ajbrowser.BrowserManager;
import org.aspectj.tools.ajbrowser.ui.BrowserMessageHandler;
import org.aspectj.tools.ajbrowser.ui.swing.TopFrame;

public class BrowserBuildProgressMonitor
extends Thread
implements IBuildProgressMonitor {
    public static final String PROGRESS_HEADING = "AspectJ Build";
    private BuildProgressPanel progressDialog = null;
    private JDialog dialog = null;
    private TopFrame topFrame;
    private BrowserMessageHandler handler;

    public BrowserBuildProgressMonitor(BrowserMessageHandler handler) {
        this.handler = handler;
        this.topFrame = (TopFrame)BrowserManager.getDefault().getRootFrame();
        this.dialog = new JDialog(this.topFrame, PROGRESS_HEADING, false);
        this.progressDialog = new BuildProgressPanel();
        this.dialog.setContentPane(this.progressDialog);
        this.dialog.setSize(550, 120);
        try {
            this.dialog.setLocationRelativeTo(this.topFrame);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void finish(boolean wasFullBuild) {
        Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("build finished...");
        this.progressDialog.finish();
        this.dialog.dispose();
        if (this.handler.getMessages().isEmpty()) {
            this.topFrame.hideMessagesPanel(this.handler);
        } else {
            this.topFrame.showMessagesPanel(this.handler);
        }
    }

    @Override
    public boolean isCancelRequested() {
        boolean isCancel = this.progressDialog.isCancelRequested();
        if (isCancel) {
            Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("Compile aborted");
        }
        return isCancel;
    }

    @Override
    public void setProgress(double percentDone) {
        this.progressDialog.setProgressBarVal((int)(percentDone * (double)this.progressDialog.getProgressBarMax()));
    }

    @Override
    public void setProgressText(String text) {
        Ajde.getDefault().getIdeUIAdapter().displayStatusInformation(text);
        this.progressDialog.setProgressText(text);
    }

    @Override
    public void begin() {
        Ajde.getDefault().getIdeUIAdapter().displayStatusInformation("starting build...");
        this.handler.reset();
        this.progressDialog.setProgressBarVal(0);
        this.progressDialog.setProgressText("starting build...");
        this.dialog.setLocationRelativeTo(Ajde.getDefault().getRootFrame());
        this.dialog.setVisible(true);
    }
}

