/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;

public class SwingTreeViewNode
extends DefaultMutableTreeNode
implements IStructureViewNode {
    private static final long serialVersionUID = 4957761341510335532L;
    private String relationshipName;
    private IProgramElement programElement;
    private AbstractIcon icon;
    private IStructureViewNode.Kind kind;

    public SwingTreeViewNode(IProgramElement programElement, AbstractIcon icon, List children) {
        super(programElement, true);
        this.programElement = programElement;
        this.icon = icon;
        this.kind = IStructureViewNode.Kind.DECLARATION;
        if (children != null) {
            for (Object o : children) {
                SwingTreeViewNode child = (SwingTreeViewNode)o;
                if (!StructureViewNodeFactory.acceptNode(programElement, child.getStructureNode())) continue;
                super.add(child);
            }
        }
    }

    public SwingTreeViewNode(IRelationship relationship, AbstractIcon icon) {
        super(null, true);
        this.icon = icon;
        this.kind = IStructureViewNode.Kind.RELATIONSHIP;
        this.relationshipName = relationship.getName();
    }

    public SwingTreeViewNode(IProgramElement programElement, AbstractIcon icon) {
        super(programElement, false);
        this.programElement = programElement;
        this.kind = IStructureViewNode.Kind.LINK;
        this.icon = icon;
    }

    @Override
    public IProgramElement getStructureNode() {
        return this.programElement;
    }

    @Override
    public AbstractIcon getIcon() {
        return this.icon;
    }

    @Override
    public void add(IStructureViewNode child) {
        super.add((DefaultMutableTreeNode)((Object)child));
    }

    @Override
    public void add(IStructureViewNode child, int position) {
        super.insert((DefaultMutableTreeNode)((Object)child), position);
    }

    @Override
    public void remove(IStructureViewNode child) {
        super.remove((DefaultMutableTreeNode)((Object)child));
    }

    @Override
    public List getChildren() {
        if (this.children == null) {
            return new ArrayList();
        }
        return this.children;
    }

    @Override
    public IStructureViewNode.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getRelationshipName() {
        return this.relationshipName;
    }

    @Override
    public String toString() {
        if (this.kind == IStructureViewNode.Kind.RELATIONSHIP) {
            return this.relationshipName;
        }
        if (this.kind == IStructureViewNode.Kind.LINK) {
            return this.programElement.toLinkLabelString();
        }
        return this.programElement.toLabelString();
    }
}

