/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.Utility;

public final class CodeException
implements Cloneable,
Constants,
Node,
Serializable {
    private int start_pc;
    private int end_pc;
    private int handler_pc;
    private int catch_type;

    public CodeException(CodeException codeException) {
        this(codeException.getStartPC(), codeException.getEndPC(), codeException.getHandlerPC(), codeException.getCatchType());
    }

    CodeException(DataInputStream dataInputStream) throws IOException {
        this.start_pc = dataInputStream.readUnsignedShort();
        this.end_pc = dataInputStream.readUnsignedShort();
        this.handler_pc = dataInputStream.readUnsignedShort();
        this.catch_type = dataInputStream.readUnsignedShort();
    }

    public CodeException(int n, int n2, int n3, int n4) {
        this.start_pc = n;
        this.end_pc = n2;
        this.handler_pc = n3;
        this.catch_type = n4;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitCodeException(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.start_pc);
        dataOutputStream.writeShort(this.end_pc);
        dataOutputStream.writeShort(this.handler_pc);
        dataOutputStream.writeShort(this.catch_type);
    }

    public final int getCatchType() {
        return this.catch_type;
    }

    public final int getEndPC() {
        return this.end_pc;
    }

    public final int getHandlerPC() {
        return this.handler_pc;
    }

    public final int getStartPC() {
        return this.start_pc;
    }

    public final void setCatchType(int n) {
        this.catch_type = n;
    }

    public final void setEndPC(int n) {
        this.end_pc = n;
    }

    public final void setHandlerPC(int n) {
        this.handler_pc = n;
    }

    public final void setStartPC(int n) {
        this.start_pc = n;
    }

    public final String toString() {
        return "CodeException(start_pc = " + this.start_pc + ", end_pc = " + this.end_pc + ", handler_pc = " + this.handler_pc + ", catch_type = " + this.catch_type + ")";
    }

    public final String toString(ConstantPool constantPool, boolean bl) {
        String string = this.catch_type == 0 ? "<Any exception>(0)" : Utility.compactClassName(constantPool.getConstantString(this.catch_type, (byte)7), false) + (bl ? "(" + this.catch_type + ")" : "");
        return this.start_pc + "\t" + this.end_pc + "\t" + this.handler_pc + "\t" + string;
    }

    public final String toString(ConstantPool constantPool) {
        return this.toString(constantPool, true);
    }

    public CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

