/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.SimpleConstant;

public final class ConstantInteger
extends Constant
implements SimpleConstant {
    private int intValue;

    public ConstantInteger(int n) {
        super((byte)3);
        this.intValue = n;
    }

    ConstantInteger(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readInt());
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantInteger(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeInt(this.intValue);
    }

    @Override
    public final String toString() {
        return super.toString() + "(bytes = " + this.intValue + ")";
    }

    @Override
    public Integer getValue() {
        return this.intValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    @Override
    public String getStringValue() {
        return Integer.toString(this.intValue);
    }
}

