/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;

public final class ConstantString
extends Constant {
    private int stringIndex;

    ConstantString(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort());
    }

    public ConstantString(int n) {
        super((byte)8);
        this.stringIndex = n;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantString(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.stringIndex);
    }

    @Override
    public Integer getValue() {
        return this.stringIndex;
    }

    public final int getStringIndex() {
        return this.stringIndex;
    }

    @Override
    public final String toString() {
        return super.toString() + "(string_index = " + this.stringIndex + ")";
    }

    public String getString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.stringIndex, (byte)1);
        return ((ConstantUtf8)constant).getValue();
    }
}

