/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.Type;

public class InstructionByte
extends Instruction {
    private final byte theByte;

    public InstructionByte(short s, byte by) {
        super(s);
        this.theByte = by;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeByte(this.theByte);
    }

    @Override
    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.theByte;
    }

    public final byte getTypecode() {
        return this.theByte;
    }

    @Override
    public final Type getType() {
        return new ArrayType(BasicType.getType(this.theByte), 1);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof InstructionByte)) {
            return false;
        }
        InstructionByte instructionByte = (InstructionByte)object;
        return instructionByte.opcode == this.opcode && instructionByte.theByte == this.theByte;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37 + this.theByte;
    }
}

