/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.BranchHandle;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.CodeExceptionGen;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionCP;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.LocalVariableGen;
import org.aspectj.apache.bcel.generic.TargetLostException;
import org.aspectj.apache.bcel.util.ByteSequence;

public class InstructionList
implements Serializable {
    private InstructionHandle start = null;
    private InstructionHandle end = null;
    private int length = 0;
    private int[] positions;

    public InstructionList() {
    }

    public InstructionList(Instruction instruction) {
        this.append(instruction);
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    public static InstructionHandle findHandle(InstructionHandle[] instructionHandleArray, int[] nArray, int n, int n2) {
        return InstructionList.findHandle(instructionHandleArray, nArray, n, n2, false);
    }

    public static InstructionHandle findHandle(InstructionHandle[] instructionHandleArray, int[] nArray, int n, int n2, boolean bl) {
        int n3;
        int n4 = 0;
        int n5 = n - 1;
        do {
            int n6;
            if ((n6 = nArray[n3 = (n4 + n5) / 2]) == n2) {
                return instructionHandleArray[n3];
            }
            if (n2 < n6) {
                n5 = n3 - 1;
                continue;
            }
            n4 = n3 + 1;
        } while (n4 <= n5);
        if (bl) {
            n3 = (n4 + n5) / 2;
            if (n3 < 0) {
                n3 = 0;
            }
            return instructionHandleArray[n3];
        }
        return null;
    }

    public InstructionHandle findHandle(int n) {
        InstructionHandle[] instructionHandleArray = this.getInstructionHandles();
        return InstructionList.findHandle(instructionHandleArray, this.positions, this.length, n);
    }

    public InstructionHandle[] getInstructionsAsArray() {
        return this.getInstructionHandles();
    }

    public InstructionHandle findHandle(int n, InstructionHandle[] instructionHandleArray) {
        return InstructionList.findHandle(instructionHandleArray, this.positions, this.length, n);
    }

    public InstructionHandle findHandle(int n, InstructionHandle[] instructionHandleArray, boolean bl) {
        return InstructionList.findHandle(instructionHandleArray, this.positions, this.length, n, bl);
    }

    public InstructionList(byte[] byArray) {
        Instruction instruction;
        int n;
        ByteSequence byteSequence = new ByteSequence(byArray);
        InstructionHandle[] instructionHandleArray = new InstructionHandle[byArray.length];
        int[] nArray = new int[byArray.length];
        int n2 = 0;
        try {
            while (byteSequence.available() > 0) {
                nArray[n2] = n = byteSequence.getIndex();
                instruction = Instruction.readInstruction(byteSequence);
                InstructionHandle instructionHandle = instruction instanceof InstructionBranch ? this.append((InstructionBranch)instruction) : this.append(instruction);
                instructionHandle.setPosition(n);
                instructionHandleArray[n2] = instructionHandle;
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString());
        }
        this.positions = new int[n2];
        System.arraycopy(nArray, 0, this.positions, 0, n2);
        for (n = 0; n < n2; ++n) {
            if (!(instructionHandleArray[n] instanceof BranchHandle)) continue;
            instruction = (InstructionBranch)instructionHandleArray[n].instruction;
            int n3 = ((InstructionBranch)instruction).positionOfThisInstruction + ((InstructionBranch)instruction).getIndex();
            InstructionHandle instructionHandle = InstructionList.findHandle(instructionHandleArray, nArray, n2, n3);
            if (instructionHandle == null) {
                throw new ClassGenException("Couldn't find target for branch: " + instruction);
            }
            ((InstructionBranch)instruction).setTarget(instructionHandle);
            if (!(instruction instanceof InstructionSelect)) continue;
            InstructionSelect instructionSelect = (InstructionSelect)instruction;
            int[] nArray2 = instructionSelect.getIndices();
            for (int i = 0; i < nArray2.length; ++i) {
                n3 = ((InstructionBranch)instruction).positionOfThisInstruction + nArray2[i];
                instructionHandle = InstructionList.findHandle(instructionHandleArray, nArray, n2, n3);
                if (instructionHandle == null) {
                    throw new ClassGenException("Couldn't find target for switch: " + instruction);
                }
                instructionSelect.setTarget(i, instructionHandle);
            }
        }
    }

    public InstructionHandle append(InstructionHandle instructionHandle, InstructionList instructionList) {
        assert (instructionList != null);
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.next;
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.next = instructionList.start;
        instructionList.start.prev = instructionHandle;
        instructionList.end.next = instructionHandle2;
        if (instructionHandle2 != null) {
            instructionHandle2.prev = instructionList.end;
        } else {
            this.end = instructionList.end;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle append(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction2(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.append(instructionHandle, instructionList);
    }

    public InstructionHandle append(InstructionList instructionList) {
        assert (instructionList != null);
        if (instructionList.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = instructionList.start;
            this.end = instructionList.end;
            this.length = instructionList.length;
            instructionList.clear();
            return this.start;
        }
        return this.append(this.end, instructionList);
    }

    private void append(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.prev = null;
            instructionHandle.next = null;
        } else {
            this.end.next = instructionHandle;
            instructionHandle.prev = this.end;
            instructionHandle.next = null;
            this.end = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle append(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.append(instructionHandle);
        return instructionHandle;
    }

    public InstructionHandle appendDUP() {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(InstructionConstants.DUP);
        this.append(instructionHandle);
        return instructionHandle;
    }

    public InstructionHandle appendNOP() {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(InstructionConstants.NOP);
        this.append(instructionHandle);
        return instructionHandle;
    }

    public InstructionHandle appendPOP() {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(InstructionConstants.POP);
        this.append(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle append(InstructionBranch instructionBranch) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(instructionBranch);
        this.append(branchHandle);
        return branchHandle;
    }

    public InstructionHandle append(Instruction instruction, Instruction instruction2) {
        return this.append(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle append(InstructionHandle instructionHandle, Instruction instruction) {
        return this.append(instructionHandle, new InstructionList(instruction));
    }

    public BranchHandle append(InstructionHandle instructionHandle, InstructionBranch instructionBranch) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(instructionBranch);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.append(instructionHandle, instructionList);
        return branchHandle;
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, InstructionList instructionList) {
        if (instructionList == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (instructionList.isEmpty()) {
            return instructionHandle;
        }
        InstructionHandle instructionHandle2 = instructionHandle.prev;
        InstructionHandle instructionHandle3 = instructionList.start;
        instructionHandle.prev = instructionList.end;
        instructionList.end.next = instructionHandle;
        instructionList.start.prev = instructionHandle2;
        if (instructionHandle2 != null) {
            instructionHandle2.next = instructionList.start;
        } else {
            this.start = instructionList.start;
        }
        this.length += instructionList.length;
        instructionList.clear();
        return instructionHandle3;
    }

    public InstructionHandle insert(InstructionList instructionList) {
        if (this.isEmpty()) {
            this.append(instructionList);
            return this.start;
        }
        return this.insert(this.start, instructionList);
    }

    private void insert(InstructionHandle instructionHandle) {
        if (this.isEmpty()) {
            this.start = this.end = instructionHandle;
            instructionHandle.prev = null;
            instructionHandle.next = null;
        } else {
            this.start.prev = instructionHandle;
            instructionHandle.next = this.start;
            instructionHandle.prev = null;
            this.start = instructionHandle;
        }
        ++this.length;
    }

    public InstructionHandle insert(Instruction instruction, InstructionList instructionList) {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        return this.insert(instructionHandle, instructionList);
    }

    public InstructionHandle insert(Instruction instruction) {
        InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
        this.insert(instructionHandle);
        return instructionHandle;
    }

    public BranchHandle insert(InstructionBranch instructionBranch) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(instructionBranch);
        this.insert(branchHandle);
        return branchHandle;
    }

    public InstructionHandle insert(Instruction instruction, Instruction instruction2) {
        return this.insert(instruction, new InstructionList(instruction2));
    }

    public InstructionHandle insert(InstructionHandle instructionHandle, Instruction instruction) {
        return this.insert(instructionHandle, new InstructionList(instruction));
    }

    public BranchHandle insert(InstructionHandle instructionHandle, InstructionBranch instructionBranch) {
        BranchHandle branchHandle = BranchHandle.getBranchHandle(instructionBranch);
        InstructionList instructionList = new InstructionList();
        instructionList.append(branchHandle);
        this.insert(instructionHandle, instructionList);
        return branchHandle;
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3) {
        if (instructionHandle == null || instructionHandle2 == null) {
            throw new ClassGenException("Invalid null handle: From " + instructionHandle + " to " + instructionHandle2);
        }
        if (instructionHandle3 == instructionHandle || instructionHandle3 == instructionHandle2) {
            throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
        }
        InstructionHandle instructionHandle4 = instructionHandle;
        while (instructionHandle4 != instructionHandle2.next) {
            if (instructionHandle4 == null) {
                throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2);
            }
            if (instructionHandle4 == instructionHandle3) {
                throw new ClassGenException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
            }
            instructionHandle4 = instructionHandle4.next;
        }
        instructionHandle4 = instructionHandle.prev;
        InstructionHandle instructionHandle5 = instructionHandle2.next;
        if (instructionHandle4 != null) {
            instructionHandle4.next = instructionHandle5;
        } else {
            this.start = instructionHandle5;
        }
        if (instructionHandle5 != null) {
            instructionHandle5.prev = instructionHandle4;
        } else {
            this.end = instructionHandle4;
        }
        instructionHandle2.next = null;
        instructionHandle.prev = null;
        if (instructionHandle3 == null) {
            instructionHandle2.next = this.start;
            this.start = instructionHandle;
        } else {
            instructionHandle5 = instructionHandle3.next;
            instructionHandle3.next = instructionHandle;
            instructionHandle.prev = instructionHandle3;
            instructionHandle2.next = instructionHandle5;
            if (instructionHandle5 != null) {
                instructionHandle5.prev = instructionHandle2;
            }
        }
    }

    public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        this.move(instructionHandle, instructionHandle, instructionHandle2);
    }

    private void remove(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, boolean bl) throws TargetLostException {
        InstructionHandle[] instructionHandleArray;
        InstructionHandle instructionHandle3;
        if (instructionHandle == null && instructionHandle2 == null) {
            instructionHandle3 = this.start;
            instructionHandleArray = instructionHandle3;
            this.end = null;
            this.start = null;
        } else {
            if (instructionHandle == null) {
                instructionHandleArray = this.start;
                this.start = instructionHandle2;
            } else {
                instructionHandleArray = instructionHandle.next;
                instructionHandle.next = instructionHandle2;
            }
            if (instructionHandle2 == null) {
                instructionHandle3 = this.end;
                this.end = instructionHandle;
            } else {
                instructionHandle3 = instructionHandle2.prev;
                instructionHandle2.prev = instructionHandle;
            }
        }
        instructionHandleArray.prev = null;
        instructionHandle3.next = null;
        if (!bl) {
            return;
        }
        ArrayList<InstructionHandle[]> arrayList = new ArrayList<InstructionHandle[]>();
        Serializable serializable = instructionHandleArray;
        while (serializable != null) {
            ((InstructionHandle)serializable).getInstruction().dispose();
            serializable = ((InstructionHandle)serializable).next;
        }
        serializable = new StringBuffer("{ ");
        Object object = instructionHandleArray;
        while (object != null) {
            instructionHandle2 = ((InstructionHandle)object).next;
            --this.length;
            Set<InstructionTargeter> set = ((InstructionHandle)object).getTargeters();
            boolean bl2 = false;
            for (InstructionTargeter instructionTargeter : set) {
                if (instructionTargeter.getClass().getName().endsWith("ShadowRange") || instructionTargeter.getClass().getName().endsWith("ExceptionRange") || instructionTargeter.getClass().getName().endsWith("LineNumberTag")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(instructionTargeter.getClass());
            }
            if (!bl2) {
                arrayList.add((InstructionHandle[])object);
                ((StringBuffer)serializable).append(((InstructionHandle)object).toString(true) + " ");
                ((InstructionHandle)object).prev = null;
                ((InstructionHandle)object).next = null;
            } else {
                ((InstructionHandle)object).dispose();
            }
            object = instructionHandle2;
        }
        ((StringBuffer)serializable).append("}");
        if (!arrayList.isEmpty()) {
            object = new InstructionHandle[arrayList.size()];
            arrayList.toArray((T[])object);
            throw new TargetLostException((InstructionHandle[])object, ((StringBuffer)serializable).toString());
        }
    }

    public void delete(InstructionHandle instructionHandle) throws TargetLostException {
        this.remove(instructionHandle.prev, instructionHandle.next, false);
    }

    public void delete(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
        this.remove(instructionHandle.prev, instructionHandle2.next, false);
    }

    public void delete(Instruction instruction, Instruction instruction2) throws TargetLostException {
        InstructionHandle instructionHandle = this.findInstruction1(instruction);
        if (instructionHandle == null) {
            throw new ClassGenException("Instruction " + instruction + " is not contained in this list.");
        }
        InstructionHandle instructionHandle2 = this.findInstruction2(instruction2);
        if (instructionHandle2 == null) {
            throw new ClassGenException("Instruction " + instruction2 + " is not contained in this list.");
        }
        this.delete(instructionHandle, instructionHandle2);
    }

    private InstructionHandle findInstruction1(Instruction instruction) {
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            if (instructionHandle.instruction == instruction) {
                return instructionHandle;
            }
            instructionHandle = instructionHandle.next;
        }
        return null;
    }

    private InstructionHandle findInstruction2(Instruction instruction) {
        InstructionHandle instructionHandle = this.end;
        while (instructionHandle != null) {
            if (instructionHandle.instruction == instruction) {
                return instructionHandle;
            }
            instructionHandle = instructionHandle.prev;
        }
        return null;
    }

    public boolean contains(InstructionHandle instructionHandle) {
        if (instructionHandle == null) {
            return false;
        }
        InstructionHandle instructionHandle2 = this.start;
        while (instructionHandle2 != null) {
            if (instructionHandle2 == instructionHandle) {
                return true;
            }
            instructionHandle2 = instructionHandle2.next;
        }
        return false;
    }

    public boolean contains(Instruction instruction) {
        return this.findInstruction1(instruction) != null;
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.length];
        if (bl) {
            this.checkInstructionList();
        }
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            Instruction instruction = instructionHandle.instruction;
            instructionHandle.setPosition(n2);
            nArray[n3++] = n2;
            switch (instruction.opcode) {
                case 167: 
                case 168: {
                    n += 2;
                    break;
                }
                case 170: 
                case 171: {
                    n += 3;
                }
            }
            n2 += instruction.getLength();
            instructionHandle = instructionHandle.next;
        }
        boolean bl2 = false;
        int n4 = 0;
        InstructionHandle instructionHandle2 = this.start;
        while (instructionHandle2 != null) {
            if (instructionHandle2 instanceof BranchHandle && (n4 += ((BranchHandle)instructionHandle2).updatePosition(n4, n)) != 0) {
                bl2 = true;
            }
            instructionHandle2 = instructionHandle2.next;
        }
        if (bl2) {
            n3 = 0;
            n2 = 0;
            instructionHandle2 = this.start;
            while (instructionHandle2 != null) {
                Instruction instruction = instructionHandle2.instruction;
                instructionHandle2.setPosition(n2);
                nArray[n3++] = n2;
                n2 += instruction.getLength();
                instructionHandle2 = instructionHandle2.next;
            }
        }
        this.positions = new int[n3];
        System.arraycopy(nArray, 0, this.positions, 0, n3);
    }

    private void checkInstructionList() {
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            Instruction instruction = instructionHandle.instruction;
            if (instruction instanceof InstructionBranch) {
                Instruction instruction2 = ((InstructionBranch)instruction).getTarget().instruction;
                if (!this.contains(instruction2)) {
                    throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not in instruction list");
                }
                if (instruction instanceof InstructionSelect) {
                    InstructionHandle[] instructionHandleArray = ((InstructionSelect)instruction).getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        instruction2 = instructionHandleArray[i].instruction;
                        if (this.contains(instruction2)) continue;
                        throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not in instruction list");
                    }
                }
                if (!(instructionHandle instanceof BranchHandle)) {
                    throw new ClassGenException("Branch instruction " + Constants.OPCODE_NAMES[instruction.opcode] + ":" + instruction2 + " not contained in BranchHandle.");
                }
            }
            instructionHandle = instructionHandle.next;
        }
    }

    public byte[] getByteCode() {
        Object object;
        this.setPositions();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            object = this.start;
            while (object != null) {
                Instruction instruction = ((InstructionHandle)object).instruction;
                instruction.dump(dataOutputStream);
                object = ((InstructionHandle)object).next;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
        object = byteArrayOutputStream.toByteArray();
        if (((Object)object).length > 65536) {
            throw new ClassGenException("Code size too big: " + ((Object)object).length);
        }
        return object;
    }

    public Instruction[] getInstructions() {
        ByteSequence byteSequence = new ByteSequence(this.getByteCode());
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        try {
            while (byteSequence.available() > 0) {
                arrayList.add(Instruction.readInstruction(byteSequence));
            }
        }
        catch (IOException iOException) {
            throw new ClassGenException(iOException.toString());
        }
        Instruction[] instructionArray = new Instruction[arrayList.size()];
        arrayList.toArray(instructionArray);
        return instructionArray;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            stringBuffer.append(instructionHandle.toString(bl) + "\n");
            instructionHandle = instructionHandle.next;
        }
        return stringBuffer.toString();
    }

    public Iterator iterator() {
        return new Iterator(){
            private InstructionHandle ih;
            {
                this.ih = InstructionList.this.start;
            }

            public Object next() {
                InstructionHandle instructionHandle = this.ih;
                this.ih = this.ih.next;
                return instructionHandle;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.ih != null;
            }
        };
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] instructionHandleArray = new InstructionHandle[this.length];
        InstructionHandle instructionHandle = this.start;
        for (int i = 0; i < this.length; ++i) {
            instructionHandleArray[i] = instructionHandle;
            instructionHandle = instructionHandle.next;
        }
        return instructionHandleArray;
    }

    public int[] getInstructionPositions() {
        return this.positions;
    }

    public InstructionList copy() {
        Instruction instruction;
        Serializable serializable;
        HashMap<InstructionHandle, InstructionHandle> hashMap = new HashMap<InstructionHandle, InstructionHandle>();
        InstructionList instructionList = new InstructionList();
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            serializable = instructionHandle.instruction;
            instruction = serializable.copy();
            if (instruction instanceof InstructionBranch) {
                hashMap.put(instructionHandle, instructionList.append((InstructionBranch)instruction));
            } else {
                hashMap.put(instructionHandle, instructionList.append(instruction));
            }
            instructionHandle = instructionHandle.next;
        }
        instructionHandle = this.start;
        serializable = instructionList.start;
        while (instructionHandle != null) {
            instruction = instructionHandle.instruction;
            Instruction instruction2 = ((InstructionHandle)serializable).instruction;
            if (instruction instanceof InstructionBranch) {
                InstructionBranch instructionBranch = (InstructionBranch)instruction;
                InstructionBranch instructionBranch2 = (InstructionBranch)instruction2;
                InstructionHandle instructionHandle2 = instructionBranch.getTarget();
                instructionBranch2.setTarget((InstructionHandle)hashMap.get(instructionHandle2));
                if (instructionBranch instanceof InstructionSelect) {
                    InstructionHandle[] instructionHandleArray = ((InstructionSelect)instructionBranch).getTargets();
                    InstructionHandle[] instructionHandleArray2 = ((InstructionSelect)instructionBranch2).getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        instructionHandleArray2[i] = (InstructionHandle)hashMap.get(instructionHandleArray[i]);
                    }
                }
            }
            instructionHandle = instructionHandle.next;
            serializable = ((InstructionHandle)serializable).next;
        }
        return instructionList;
    }

    public void replaceConstantPool(ConstantPool constantPool, ConstantPool constantPool2) {
        InstructionHandle instructionHandle = this.start;
        while (instructionHandle != null) {
            Instruction instruction = instructionHandle.instruction;
            if (instruction.isConstantPoolInstruction()) {
                InstructionCP instructionCP = (InstructionCP)instruction;
                Constant constant = constantPool.getConstant(instructionCP.getIndex());
                instructionCP.setIndex(constantPool2.addConstant(constant, constantPool));
            }
            instructionHandle = instructionHandle.next;
        }
    }

    private void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public void dispose() {
        InstructionHandle instructionHandle = this.end;
        while (instructionHandle != null) {
            instructionHandle.dispose();
            instructionHandle = instructionHandle.prev;
        }
        this.clear();
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public void redirectBranches(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        InstructionHandle instructionHandle3 = this.start;
        while (instructionHandle3 != null) {
            Instruction instruction = instructionHandle3.getInstruction();
            if (instruction instanceof InstructionBranch) {
                InstructionBranch instructionBranch = (InstructionBranch)instruction;
                InstructionHandle instructionHandle4 = instructionBranch.getTarget();
                if (instructionHandle4 == instructionHandle) {
                    instructionBranch.setTarget(instructionHandle2);
                }
                if (instructionBranch instanceof InstructionSelect) {
                    InstructionHandle[] instructionHandleArray = ((InstructionSelect)instructionBranch).getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        if (instructionHandleArray[i] != instructionHandle) continue;
                        ((InstructionSelect)instructionBranch).setTarget(i, instructionHandle2);
                    }
                }
            }
            instructionHandle3 = instructionHandle3.next;
        }
    }

    public void redirectLocalVariables(LocalVariableGen[] localVariableGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        for (int i = 0; i < localVariableGenArray.length; ++i) {
            InstructionHandle instructionHandle3 = localVariableGenArray[i].getStart();
            InstructionHandle instructionHandle4 = localVariableGenArray[i].getEnd();
            if (instructionHandle3 == instructionHandle) {
                localVariableGenArray[i].setStart(instructionHandle2);
            }
            if (instructionHandle4 != instructionHandle) continue;
            localVariableGenArray[i].setEnd(instructionHandle2);
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] codeExceptionGenArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        for (int i = 0; i < codeExceptionGenArray.length; ++i) {
            if (codeExceptionGenArray[i].getStartPC() == instructionHandle) {
                codeExceptionGenArray[i].setStartPC(instructionHandle2);
            }
            if (codeExceptionGenArray[i].getEndPC() == instructionHandle) {
                codeExceptionGenArray[i].setEndPC(instructionHandle2);
            }
            if (codeExceptionGenArray[i].getHandlerPC() != instructionHandle) continue;
            codeExceptionGenArray[i].setHandlerPC(instructionHandle2);
        }
    }
}

