/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantInvokeDynamic;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.Type;

public final class InvokeDynamic
extends InvokeInstruction {
    public InvokeDynamic(int n, int n2) {
        super((short)186, n);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
        dataOutputStream.writeShort(0);
    }

    @Override
    public String toString(ConstantPool constantPool) {
        return super.toString(constantPool) + " " + this.index;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof InvokeDynamic)) {
            return false;
        }
        InvokeDynamic invokeDynamic = (InvokeDynamic)object;
        return invokeDynamic.opcode == this.opcode && invokeDynamic.index == this.index;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37 + this.index;
    }

    @Override
    public Type getReturnType(ConstantPool constantPool) {
        return Type.getReturnType(this.getSignature(constantPool));
    }

    @Override
    public Type[] getArgumentTypes(ConstantPool constantPool) {
        return Type.getArgumentTypes(this.getSignature(constantPool));
    }

    @Override
    public String getSignature(ConstantPool constantPool) {
        if (this.signature == null) {
            ConstantInvokeDynamic constantInvokeDynamic = (ConstantInvokeDynamic)constantPool.getConstant(this.index);
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantPool.getConstant(constantInvokeDynamic.getNameAndTypeIndex());
            this.signature = constantPool.getConstantUtf8(constantNameAndType.getSignatureIndex()).getValue();
        }
        return this.signature;
    }

    @Override
    public String getName(ConstantPool constantPool) {
        if (this.name == null) {
            ConstantInvokeDynamic constantInvokeDynamic = (ConstantInvokeDynamic)constantPool.getConstant(this.index);
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantPool.getConstant(constantInvokeDynamic.getNameAndTypeIndex());
            this.name = constantPool.getConstantUtf8(constantNameAndType.getNameIndex()).getValue();
        }
        return this.name;
    }

    @Override
    public String getClassName(ConstantPool constantPool) {
        throw new IllegalStateException("there is no classname for invokedynamic");
    }
}

