/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.CodeException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.LineNumber;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeParamAnnos;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.CodeExceptionGen;
import org.aspectj.apache.bcel.generic.FieldGenOrMethodGen;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionLV;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.generic.LineNumberGen;
import org.aspectj.apache.bcel.generic.LineNumberTag;
import org.aspectj.apache.bcel.generic.LocalVariableGen;
import org.aspectj.apache.bcel.generic.LocalVariableTag;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.RET;
import org.aspectj.apache.bcel.generic.Type;

public class MethodGen
extends FieldGenOrMethodGen {
    private String classname;
    private Type[] parameterTypes;
    private String[] parameterNames;
    private int maxLocals;
    private int maxStack;
    private InstructionList il;
    private boolean stripAttributes;
    private int highestLineNumber = 0;
    private ArrayList<LocalVariableGen> localVariablesList = new ArrayList();
    private ArrayList<LineNumberGen> lineNumbersList = new ArrayList();
    private ArrayList<CodeExceptionGen> exceptionsList = new ArrayList();
    private ArrayList<String> exceptionsThrown = new ArrayList();
    private ArrayList<Attribute> codeAttributesList = new ArrayList();
    private List<AnnotationGen>[] param_annotations;
    private boolean hasParameterAnnotations = false;
    private boolean haveUnpackedParameterAnnotations = false;

    public MethodGen(int n, Type type, Type[] typeArray, String[] stringArray, String string, String string2, InstructionList instructionList, ConstantPool constantPool) {
        this.modifiers = n;
        this.type = type;
        this.parameterTypes = typeArray;
        this.parameterNames = stringArray;
        this.name = string;
        this.classname = string2;
        this.il = instructionList;
        this.cp = constantPool;
    }

    public int getHighestlinenumber() {
        return this.highestLineNumber;
    }

    public MethodGen(Method method, String string, ConstantPool constantPool) {
        this(method, string, constantPool, false);
    }

    /*
     * WARNING - void declaration
     */
    public MethodGen(Method method, String string, ConstantPool constantPool, boolean bl) {
        this(method.getModifiers(), method.getReturnType(), method.getArgumentTypes(), null, method.getName(), string, (method.getModifiers() & 0x500) == 0 ? new InstructionList(method.getCode().getCode()) : null, constantPool);
        Attribute[] attributeArray = method.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            CodeException[] codeExceptionArray;
            Object object;
            Cloneable cloneable = attributeArray[i];
            if (cloneable instanceof Code) {
                object = (String[])cloneable;
                this.setMaxStack(((Code)object).getMaxStack());
                this.setMaxLocals(((Code)object).getMaxLocals());
                codeExceptionArray = ((Code)object).getExceptionTable();
                InstructionHandle[] instructionHandleArray = this.il.getInstructionsAsArray();
                if (codeExceptionArray != null) {
                    for (Cloneable cloneable2 : codeExceptionArray) {
                        InstructionHandle instructionHandle;
                        int n = ((CodeException)cloneable2).getCatchType();
                        ObjectType objectType = null;
                        if (n > 0) {
                            String string2 = method.getConstantPool().getConstantString_CONSTANTClass(n);
                            objectType = new ObjectType(string2);
                        }
                        int n2 = ((CodeException)cloneable2).getEndPC();
                        int n3 = method.getCode().getCode().length;
                        if (n3 == n2) {
                            instructionHandle = this.il.getEnd();
                        } else {
                            instructionHandle = this.il.findHandle(n2, instructionHandleArray);
                            instructionHandle = instructionHandle.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(((CodeException)cloneable2).getStartPC(), instructionHandleArray), instructionHandle, this.il.findHandle(((CodeException)cloneable2).getHandlerPC(), instructionHandleArray), objectType);
                    }
                }
                Cloneable[] cloneableArray = ((Code)object).getAttributes();
                for (int j = 0; j < cloneableArray.length; ++j) {
                    boolean n;
                    cloneable = cloneableArray[j];
                    if (cloneable instanceof LineNumberTable) {
                        void var14_21;
                        LineNumber[] lineNumberArray = ((LineNumberTable)cloneable).getLineNumberTable();
                        if (bl) {
                            void var14_20;
                            n = false;
                            while (var14_20 < lineNumberArray.length) {
                                LineNumber lineNumber = lineNumberArray[var14_20];
                                int n4 = lineNumber.getLineNumber();
                                if (n4 > this.highestLineNumber) {
                                    this.highestLineNumber = n4;
                                }
                                LineNumberTag lineNumberTag = new LineNumberTag(n4);
                                this.il.findHandle(lineNumber.getStartPC(), instructionHandleArray, true).addTargeter(lineNumberTag);
                                ++var14_20;
                            }
                            continue;
                        }
                        n = false;
                        while (var14_21 < lineNumberArray.length) {
                            LineNumber lineNumber = lineNumberArray[var14_21];
                            this.addLineNumber(this.il.findHandle(lineNumber.getStartPC(), instructionHandleArray, true), lineNumber.getLineNumber());
                            ++var14_21;
                        }
                        continue;
                    }
                    if (cloneable instanceof LocalVariableTable) {
                        void var14_24;
                        if (bl) {
                            void var14_23;
                            LocalVariable[] localVariableArray = ((LocalVariableTable)cloneable).getLocalVariableTable();
                            n = false;
                            while (var14_23 < localVariableArray.length) {
                                int n5;
                                LocalVariable localVariable = localVariableArray[var14_23];
                                Type type = Type.getType(localVariable.getSignature());
                                LocalVariableTag localVariableTag = new LocalVariableTag(type, localVariable.getSignature(), localVariable.getName(), localVariable.getIndex(), localVariable.getStartPC());
                                InstructionHandle instructionHandle = this.il.findHandle(localVariable.getStartPC(), instructionHandleArray, true);
                                byte by = type.getType();
                                if (by != 16) {
                                    n5 = type.getSize();
                                    if (localVariable.getIndex() + n5 > this.maxLocals) {
                                        this.maxLocals = localVariable.getIndex() + n5;
                                    }
                                }
                                n5 = localVariable.getStartPC() + localVariable.getLength();
                                do {
                                    instructionHandle.addTargeter(localVariableTag);
                                } while ((instructionHandle = instructionHandle.getNext()) != null && instructionHandle.getPosition() < n5);
                                ++var14_23;
                            }
                            continue;
                        }
                        LocalVariable[] localVariableArray = ((LocalVariableTable)cloneable).getLocalVariableTable();
                        this.removeLocalVariables();
                        n = false;
                        while (var14_24 < localVariableArray.length) {
                            LocalVariable localVariable = localVariableArray[var14_24];
                            InstructionHandle instructionHandle = this.il.findHandle(localVariable.getStartPC(), instructionHandleArray);
                            InstructionHandle instructionHandle2 = this.il.findHandle(localVariable.getStartPC() + localVariable.getLength(), instructionHandleArray);
                            if (instructionHandle2 != null) {
                                instructionHandle2 = instructionHandle2.getPrev();
                            }
                            if (null == instructionHandle) {
                                instructionHandle = this.il.getStart();
                            }
                            if (null == instructionHandle2) {
                                instructionHandle2 = this.il.getEnd();
                            }
                            this.addLocalVariable(localVariable.getName(), Type.getType(localVariable.getSignature()), localVariable.getIndex(), instructionHandle, instructionHandle2);
                            ++var14_24;
                        }
                        continue;
                    }
                    this.addCodeAttribute((Attribute)cloneable);
                }
                continue;
            }
            if (cloneable instanceof ExceptionTable) {
                object = ((ExceptionTable)cloneable).getExceptionNames();
                for (int j = 0; j < ((Object)object).length; ++j) {
                    this.addException((String)object[j]);
                }
                continue;
            }
            if (cloneable instanceof RuntimeAnnos) {
                object = (RuntimeAnnos)cloneable;
                codeExceptionArray = ((RuntimeAnnos)object).getAnnotations();
                this.annotationList.addAll(codeExceptionArray);
                continue;
            }
            this.addAttribute((Attribute)cloneable);
        }
    }

    public LocalVariableGen addLocalVariable(String string, Type type, int n, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        LocalVariableGen localVariableGen;
        int n2;
        int n3 = type.getSize();
        if (n + n3 > this.maxLocals) {
            this.maxLocals = n + n3;
        }
        if ((n2 = this.localVariablesList.indexOf(localVariableGen = new LocalVariableGen(n, string, type, instructionHandle, instructionHandle2))) >= 0) {
            this.localVariablesList.set(n2, localVariableGen);
        } else {
            this.localVariablesList.add(localVariableGen);
        }
        return localVariableGen;
    }

    public LocalVariableGen addLocalVariable(String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        return this.addLocalVariable(string, type, this.maxLocals, instructionHandle, instructionHandle2);
    }

    public void removeLocalVariable(LocalVariableGen localVariableGen) {
        this.localVariablesList.remove(localVariableGen);
    }

    public void removeLocalVariables() {
        this.localVariablesList.clear();
    }

    private static final void sort(LocalVariableGen[] localVariableGenArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = localVariableGenArray[(n + n2) / 2].getIndex();
        while (true) {
            if (localVariableGenArray[n3].getIndex() < n5) {
                ++n3;
                continue;
            }
            while (n5 < localVariableGenArray[n4].getIndex()) {
                --n4;
            }
            if (n3 <= n4) {
                LocalVariableGen localVariableGen = localVariableGenArray[n3];
                localVariableGenArray[n3] = localVariableGenArray[n4];
                localVariableGenArray[n4] = localVariableGen;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            MethodGen.sort(localVariableGenArray, n, n4);
        }
        if (n3 < n2) {
            MethodGen.sort(localVariableGenArray, n3, n2);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int n = this.localVariablesList.size();
        LocalVariableGen[] localVariableGenArray = new LocalVariableGen[n];
        this.localVariablesList.toArray(localVariableGenArray);
        for (int i = 0; i < n; ++i) {
            if (localVariableGenArray[i].getStart() == null) {
                localVariableGenArray[i].setStart(this.il.getStart());
            }
            if (localVariableGenArray[i].getEnd() != null) continue;
            localVariableGenArray[i].setEnd(this.il.getEnd());
        }
        if (n > 1) {
            MethodGen.sort(localVariableGenArray, 0, n - 1);
        }
        return localVariableGenArray;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPool constantPool) {
        LocalVariableGen[] localVariableGenArray = this.getLocalVariables();
        int n = localVariableGenArray.length;
        LocalVariable[] localVariableArray = new LocalVariable[n];
        for (int i = 0; i < n; ++i) {
            localVariableArray[i] = localVariableGenArray[i].getLocalVariable(constantPool);
        }
        return new LocalVariableTable(constantPool.addUtf8("LocalVariableTable"), 2 + localVariableArray.length * 10, localVariableArray, constantPool);
    }

    public LineNumberGen addLineNumber(InstructionHandle instructionHandle, int n) {
        LineNumberGen lineNumberGen = new LineNumberGen(instructionHandle, n);
        this.lineNumbersList.add(lineNumberGen);
        return lineNumberGen;
    }

    public void removeLineNumber(LineNumberGen lineNumberGen) {
        this.lineNumbersList.remove(lineNumberGen);
    }

    public void removeLineNumbers() {
        this.lineNumbersList.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lineNumberGenArray = new LineNumberGen[this.lineNumbersList.size()];
        this.lineNumbersList.toArray(lineNumberGenArray);
        return lineNumberGenArray;
    }

    public LineNumberTable getLineNumberTable(ConstantPool constantPool) {
        int n = this.lineNumbersList.size();
        LineNumber[] lineNumberArray = new LineNumber[n];
        for (int i = 0; i < n; ++i) {
            lineNumberArray[i] = this.lineNumbersList.get(i).getLineNumber();
        }
        return new LineNumberTable(constantPool.addUtf8("LineNumberTable"), 2 + lineNumberArray.length * 4, lineNumberArray, constantPool);
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        if (instructionHandle == null || instructionHandle2 == null || instructionHandle3 == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen codeExceptionGen = new CodeExceptionGen(instructionHandle, instructionHandle2, instructionHandle3, objectType);
        this.exceptionsList.add(codeExceptionGen);
        return codeExceptionGen;
    }

    public void removeExceptionHandler(CodeExceptionGen codeExceptionGen) {
        this.exceptionsList.remove(codeExceptionGen);
    }

    public void removeExceptionHandlers() {
        this.exceptionsList.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray = new CodeExceptionGen[this.exceptionsList.size()];
        this.exceptionsList.toArray(codeExceptionGenArray);
        return codeExceptionGenArray;
    }

    private CodeException[] getCodeExceptions() {
        int n = this.exceptionsList.size();
        CodeException[] codeExceptionArray = new CodeException[n];
        try {
            for (int i = 0; i < n; ++i) {
                CodeExceptionGen codeExceptionGen = this.exceptionsList.get(i);
                codeExceptionArray[i] = codeExceptionGen.getCodeException(this.cp);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return codeExceptionArray;
    }

    public void addException(String string) {
        this.exceptionsThrown.add(string);
    }

    public void removeException(String string) {
        this.exceptionsThrown.remove(string);
    }

    public void removeExceptions() {
        this.exceptionsThrown.clear();
    }

    public String[] getExceptions() {
        String[] stringArray = new String[this.exceptionsThrown.size()];
        this.exceptionsThrown.toArray(stringArray);
        return stringArray;
    }

    private ExceptionTable getExceptionTable(ConstantPool constantPool) {
        int n = this.exceptionsThrown.size();
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = constantPool.addClass(this.exceptionsThrown.get(i));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new ExceptionTable(constantPool.addUtf8("Exceptions"), 2 + 2 * n, nArray, constantPool);
    }

    public void addCodeAttribute(Attribute attribute) {
        this.codeAttributesList.add(attribute);
    }

    public void addParameterAnnotationsAsAttribute(ConstantPool constantPool) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attributeArray = Utility.getParameterAnnotationAttributes(constantPool, this.param_annotations);
        if (attributeArray != null) {
            for (int i = 0; i < attributeArray.length; ++i) {
                this.addAttribute(attributeArray[i]);
            }
        }
    }

    public void removeCodeAttribute(Attribute attribute) {
        this.codeAttributesList.remove(attribute);
    }

    public void removeCodeAttributes() {
        this.codeAttributesList.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributeArray = new Attribute[this.codeAttributesList.size()];
        this.codeAttributesList.toArray(attributeArray);
        return attributeArray;
    }

    public Method getMethod() {
        Object object;
        String string = this.getSignature();
        int n = this.cp.addUtf8(this.name);
        int n2 = this.cp.addUtf8(string);
        byte[] byArray = null;
        if (this.il != null) {
            try {
                byArray = this.il.getByteCode();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unexpected problem whilst preparing bytecode for " + this.getClassName() + "." + this.getName() + this.getSignature(), exception);
            }
        }
        LineNumberTable lineNumberTable = null;
        LocalVariableTable localVariableTable = null;
        if (this.localVariablesList.size() > 0 && !this.stripAttributes) {
            localVariableTable = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(localVariableTable);
        }
        if (this.lineNumbersList.size() > 0 && !this.stripAttributes) {
            lineNumberTable = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lineNumberTable);
        }
        Attribute[] attributeArray = this.getCodeAttributes();
        int n3 = 0;
        for (int i = 0; i < attributeArray.length; ++i) {
            n3 += attributeArray[i].getLength() + 6;
        }
        CodeException[] codeExceptionArray = this.getCodeExceptions();
        int n4 = codeExceptionArray.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract()) {
            object = this.getAttributes();
            for (int i = 0; i < object.size(); ++i) {
                Attribute attribute = object.get(i);
                if (!(attribute instanceof Code)) continue;
                this.removeAttribute(attribute);
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byArray.length + 2 + n4 + 2 + n3, this.maxStack, this.maxLocals, byArray, codeExceptionArray, attributeArray, this.cp);
            this.addAttribute(code);
        }
        this.addAnnotationsAsAttribute(this.cp);
        this.addParameterAnnotationsAsAttribute(this.cp);
        object = null;
        if (this.exceptionsThrown.size() > 0) {
            object = this.getExceptionTable(this.cp);
            this.addAttribute((Attribute)object);
        }
        Method method = new Method(this.modifiers, n, n2, this.getAttributesImmutable(), this.cp);
        if (localVariableTable != null) {
            this.removeCodeAttribute(localVariableTable);
        }
        if (lineNumberTable != null) {
            this.removeCodeAttribute(lineNumberTable);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (object != null) {
            this.removeAttribute((Attribute)object);
        }
        return method;
    }

    public void setMaxLocals(int n) {
        this.maxLocals = n;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxStack(int n) {
        this.maxStack = n;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public String getClassName() {
        return this.classname;
    }

    public void setClassName(String string) {
        this.classname = string;
    }

    public void setReturnType(Type type) {
        this.setType(type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] typeArray) {
        this.parameterTypes = typeArray;
    }

    public Type[] getArgumentTypes() {
        return this.parameterTypes;
    }

    public void setArgumentType(int n, Type type) {
        this.parameterTypes[n] = type;
    }

    public Type getArgumentType(int n) {
        return this.parameterTypes[n];
    }

    public void setArgumentNames(String[] stringArray) {
        this.parameterNames = stringArray;
    }

    public String[] getArgumentNames() {
        if (this.parameterNames != null) {
            return (String[])this.parameterNames.clone();
        }
        return new String[0];
    }

    public void setArgumentName(int n, String string) {
        this.parameterNames[n] = string;
    }

    public String getArgumentName(int n) {
        return this.parameterNames[n];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList instructionList) {
        this.il = instructionList;
    }

    @Override
    public String getSignature() {
        return Utility.toMethodSignature(this.type, this.parameterTypes);
    }

    public void setMaxStack() {
        this.maxStack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        this.setMaxLocals(false);
    }

    public void setMaxLocals(boolean bl) {
        if (this.il != null) {
            int n;
            int n2 = n = this.isStatic() ? 0 : 1;
            if (this.parameterTypes != null) {
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    n += this.parameterTypes[i].getSize();
                }
            }
            for (InstructionHandle instructionHandle = this.il.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
                int n3;
                Instruction instruction = instructionHandle.getInstruction();
                if (!(instruction instanceof InstructionLV) && !(instruction instanceof RET) || (n3 = instruction.getIndex() + instruction.getType(this.cp).getSize()) <= n) continue;
                n = n3;
            }
            if (!bl || n > this.maxLocals) {
                this.maxLocals = n;
            }
        } else if (!bl) {
            this.maxLocals = 0;
        }
    }

    public void stripAttributes(boolean bl) {
        this.stripAttributes = bl;
    }

    public static int getMaxStack(ConstantPool constantPool, InstructionList instructionList, CodeExceptionGen[] codeExceptionGenArray) {
        BranchStack branchStack = new BranchStack();
        int n = 0;
        int n2 = 0;
        int n3 = codeExceptionGenArray.length;
        for (int i = 0; i < n3; ++i) {
            InstructionHandle instructionHandle = codeExceptionGenArray[i].getHandlerPC();
            if (instructionHandle == null) continue;
            n2 = 1;
            branchStack.push(instructionHandle, 1);
        }
        InstructionHandle instructionHandle = instructionList.getStart();
        while (instructionHandle != null) {
            Object object;
            int n4;
            Instruction instruction = instructionHandle.getInstruction();
            short s = instruction.opcode;
            int n5 = instruction.produceStack(constantPool);
            int n6 = n5 - (n4 = instruction.consumeStack(constantPool));
            if ((n += n6) > n2) {
                n2 = n;
            }
            if (instruction instanceof InstructionBranch) {
                object = (InstructionBranch)instruction;
                if (instruction instanceof InstructionSelect) {
                    InstructionSelect instructionSelect = (InstructionSelect)object;
                    InstructionHandle[] instructionHandleArray = instructionSelect.getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        branchStack.push(instructionHandleArray[i], n);
                    }
                    instructionHandle = null;
                } else if (!((InstructionBranch)object).isIfInstruction()) {
                    if (s == 168 || s == 201) {
                        branchStack.push(instructionHandle.getNext(), n - 1);
                    }
                    instructionHandle = null;
                }
                branchStack.push(((InstructionBranch)object).getTarget(), n);
            } else if (s == 191 || s == 169 || s >= 172 && s <= 177) {
                instructionHandle = null;
            }
            if (instructionHandle != null) {
                instructionHandle = instructionHandle.getNext();
            }
            if (instructionHandle != null || (object = branchStack.pop()) == null) continue;
            instructionHandle = ((BranchTarget)object).target;
            n = ((BranchTarget)object).stackDepth;
        }
        return n2;
    }

    public final String toString() {
        String string = Utility.accessToString(this.modifiers);
        String string2 = Utility.toMethodSignature(this.type, this.parameterTypes);
        string2 = Utility.methodSignatureToString(string2, this.name, string, true, this.getLocalVariableTable(this.cp));
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (this.exceptionsThrown.size() > 0) {
            Iterator<String> iterator = this.exceptionsThrown.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n\t\tthrows " + iterator.next());
            }
        }
        return stringBuffer.toString();
    }

    public List<AnnotationGen> getAnnotationsOnParameter(int n) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || n > this.parameterTypes.length) {
            return null;
        }
        return this.param_annotations[n];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        List<Attribute> list = this.getAttributes();
        RuntimeParamAnnos runtimeParamAnnos = null;
        RuntimeParamAnnos runtimeParamAnnos2 = null;
        for (Attribute attribute : list) {
            if (!(attribute instanceof RuntimeParamAnnos)) continue;
            if (!this.hasParameterAnnotations) {
                this.param_annotations = new List[this.parameterTypes.length];
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    this.param_annotations[i] = new ArrayList<AnnotationGen>();
                }
            }
            this.hasParameterAnnotations = true;
            RuntimeParamAnnos runtimeParamAnnos3 = (RuntimeParamAnnos)attribute;
            if (runtimeParamAnnos3.areVisible()) {
                runtimeParamAnnos = runtimeParamAnnos3;
            } else {
                runtimeParamAnnos2 = runtimeParamAnnos3;
            }
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                AnnotationGen[] annotationGenArray;
                for (AnnotationGen annotationGen : annotationGenArray = runtimeParamAnnos3.getAnnotationsOnParameter(i)) {
                    this.param_annotations[i].add(annotationGen);
                }
            }
        }
        if (runtimeParamAnnos != null) {
            this.removeAttribute(runtimeParamAnnos);
        }
        if (runtimeParamAnnos2 != null) {
            this.removeAttribute(runtimeParamAnnos2);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private List<AnnotationGen> makeMutableVersion(AnnotationGen[] annotationGenArray) {
        ArrayList<AnnotationGen> arrayList = new ArrayList<AnnotationGen>();
        for (int i = 0; i < annotationGenArray.length; ++i) {
            arrayList.add(new AnnotationGen(annotationGenArray[i], this.getConstantPool(), false));
        }
        return arrayList;
    }

    public void addParameterAnnotation(int n, AnnotationGen annotationGen) {
        List<AnnotationGen> list;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            this.param_annotations = new List[this.parameterTypes.length];
            this.hasParameterAnnotations = true;
        }
        if ((list = this.param_annotations[n]) != null) {
            list.add(annotationGen);
        } else {
            ArrayList<AnnotationGen> arrayList = new ArrayList<AnnotationGen>();
            arrayList.add(annotationGen);
            this.param_annotations[n] = arrayList;
        }
    }

    static final class BranchStack {
        Stack<BranchTarget> branchTargets = new Stack();
        Hashtable<InstructionHandle, BranchTarget> visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle instructionHandle, int n) {
            if (this.visited(instructionHandle)) {
                return;
            }
            this.branchTargets.push(this.visit(instructionHandle, n));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget branchTarget = this.branchTargets.pop();
                return branchTarget;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle instructionHandle, int n) {
            BranchTarget branchTarget = new BranchTarget(instructionHandle, n);
            this.visitedTargets.put(instructionHandle, branchTarget);
            return branchTarget;
        }

        private final boolean visited(InstructionHandle instructionHandle) {
            return this.visitedTargets.get(instructionHandle) != null;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle instructionHandle, int n) {
            this.target = instructionHandle;
            this.stackDepth = n;
        }
    }
}

