/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionSelect;
import org.aspectj.apache.bcel.generic.LOOKUPSWITCH;
import org.aspectj.apache.bcel.generic.TABLESWITCH;

public final class SwitchBuilder {
    private int[] match;
    private InstructionHandle[] targets;
    private InstructionSelect instruction;
    private int match_length;

    public SwitchBuilder(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle, int n) {
        this.match = (int[])nArray.clone();
        this.targets = (InstructionHandle[])instructionHandleArray.clone();
        this.match_length = nArray.length;
        if (this.match_length < 2) {
            this.instruction = nArray.length == 0 ? new LOOKUPSWITCH(nArray, instructionHandleArray, instructionHandle) : new TABLESWITCH(nArray, instructionHandleArray, instructionHandle);
        } else {
            this.sort(0, this.match_length - 1);
            if (this.matchIsOrdered(n)) {
                this.fillup(n, instructionHandle);
                this.instruction = new TABLESWITCH(this.match, this.targets, instructionHandle);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, instructionHandle);
            }
        }
    }

    public SwitchBuilder(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        this(nArray, instructionHandleArray, instructionHandle, 1);
    }

    private final void fillup(int n, InstructionHandle instructionHandle) {
        int n2 = this.match_length + this.match_length * n;
        int[] nArray = new int[n2];
        InstructionHandle[] instructionHandleArray = new InstructionHandle[n2];
        int n3 = 1;
        nArray[0] = this.match[0];
        instructionHandleArray[0] = this.targets[0];
        for (int i = 1; i < this.match_length; ++i) {
            int n4 = this.match[i - 1];
            int n5 = this.match[i] - n4;
            for (int j = 1; j < n5; ++j) {
                nArray[n3] = n4 + j;
                instructionHandleArray[n3] = instructionHandle;
                ++n3;
            }
            nArray[n3] = this.match[i];
            instructionHandleArray[n3] = this.targets[i];
            ++n3;
        }
        this.match = new int[n3];
        this.targets = new InstructionHandle[n3];
        System.arraycopy(nArray, 0, this.match, 0, n3);
        System.arraycopy(instructionHandleArray, 0, this.targets, 0, n3);
    }

    private final void sort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.match[(n + n2) / 2];
        while (true) {
            if (this.match[n3] < n5) {
                ++n3;
                continue;
            }
            while (n5 < this.match[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = this.match[n3];
                this.match[n3] = this.match[n4];
                this.match[n4] = n6;
                InstructionHandle instructionHandle = this.targets[n3];
                this.targets[n3] = this.targets[n4];
                this.targets[n4] = instructionHandle;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.sort(n, n4);
        }
        if (n3 < n2) {
            this.sort(n3, n2);
        }
    }

    private final boolean matchIsOrdered(int n) {
        for (int i = 1; i < this.match_length; ++i) {
            int n2 = this.match[i] - this.match[i - 1];
            if (n2 <= n && n2 >= 0) continue;
            return false;
        }
        return true;
    }

    public final InstructionSelect getInstruction() {
        return this.instruction;
    }
}

