/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectEnumerableAssert;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.MethodInvocationResultExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIterableAssert<S extends AbstractIterableAssert<S, A, T>, A extends Iterable<T>, T>
extends AbstractAssert<S, A>
implements ObjectEnumerableAssert<S, T> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();

    protected AbstractIterableAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S contains(T ... values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsOnly(T ... values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsOnlyOnce(T ... values) {
        this.iterables.assertContainsOnlyOnce(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsExactly(T ... values) {
        this.iterables.assertContainsExactly(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    public S isSubsetOf(Iterable<? extends T> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsSequence(T ... sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsSubsequence(T ... sequence) {
        this.iterables.assertContainsSubsequence(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContain(T ... values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (S)((AbstractIterableAssert)this.myself);
    }

    public S doesNotContainAnyElementsOf(Iterable<? extends T> iterable) {
        this.iterables.assertDoesNotContainAnyElementsOf(this.info, (Iterable)this.actual, iterable);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S startsWith(T ... sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S endsWith(T ... sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S are(Condition<? super T> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areNot(Condition<? super T> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S have(Condition<? super T> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S doNotHave(Condition<? super T> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S areExactly(int times, Condition<? super T> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtLeast(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveAtMost(int times, Condition<? super T> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S haveExactly(int times, Condition<? super T> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S containsAll(Iterable<? extends T> iterable) {
        this.iterables.assertContainsAll(this.info, (Iterable)this.actual, iterable);
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> customComparator) {
        this.iterables = new Iterables(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractIterableAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.iterables = Iterables.instance();
        return (S)((AbstractIterableAssert)this.myself);
    }

    public ListAssert<Object> extracting(String propertyOrField) {
        List<Object> values = FieldsOrPropertiesExtractor.extract(propertyOrField, (Iterable)this.actual);
        return new ListAssert<Object>(values);
    }

    public ListAssert<Object> extractingResultOf(String method) {
        List<Object> values = MethodInvocationResultExtractor.extractResultOf(method, (Iterable)this.actual);
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extractingResultOf(String method, Class<P> extractedType) {
        List<Object> values = MethodInvocationResultExtractor.extractResultOf(method, (Iterable)this.actual);
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extracting(String propertyOrField, Class<P> extractingType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract(propertyOrField, (Iterable)this.actual);
        return new ListAssert<Object>(values);
    }

    public ListAssert<Tuple> extracting(String ... propertiesOrFields) {
        List<Tuple> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, propertiesOrFields);
        return new ListAssert<Tuple>(values);
    }

    public S containsExactlyElementsOf(Iterable<? extends T> iterable) {
        return (S)this.containsExactly((Object[])org.assertj.core.util.Iterables.toArray(iterable));
    }
}

