/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.description.Description;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.ToString;
import org.assertj.core.util.VisibleForTesting;

public class MessageFormatter {
    private static final MessageFormatter INSTANCE = new MessageFormatter();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static MessageFormatter instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    MessageFormatter() {
    }

    public String format(Description d, String format, Object ... args) {
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(args);
        return this.descriptionFormatter.format(d) + Strings.formatIfArgs(format, this.format(args));
    }

    private Object[] format(Object[] args) {
        int argCount = args.length;
        Object[] formatted = new String[argCount];
        for (int i = 0; i < argCount; ++i) {
            formatted[i] = this.asText(args[i]);
        }
        return formatted;
    }

    private String asText(Object o) {
        if (o instanceof ComparatorBasedComparisonStrategy) {
            return "according to " + o + " comparator";
        }
        if (o instanceof StandardComparisonStrategy) {
            return "";
        }
        return ToString.toStringOf(o);
    }
}

