/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.ArrayWrapperList;

public class ShouldBeSorted
extends BasicErrorMessageFactory {
    private ShouldBeSorted(String format, Object ... arguments) {
        super(format, arguments);
    }

    public static ErrorMessageFactory shouldBeSorted(int i, Object group) {
        List<?> groupAsList = ShouldBeSorted.groupAsList(group);
        return new ShouldBeSorted("\ngroup is not sorted because element %s:\n <%s>\nis not less or equal than element %s:\n <%s>\ngroup was:\n <%s>", i, groupAsList.get(i), i + 1, groupAsList.get(i + 1), groupAsList);
    }

    public static ErrorMessageFactory shouldBeSortedAccordingToGivenComparator(int i, Object group, Comparator<?> comparator) {
        List<?> arrayWrapper = ShouldBeSorted.groupAsList(group);
        return new ShouldBeSorted("\ngroup is not sorted according to %s comparator because element %s:\n <%s>\nis not less or equal than element %s:\n <%s>\ngroup was:\n <%s>", comparator, i, arrayWrapper.get(i), i + 1, arrayWrapper.get(i + 1), arrayWrapper);
    }

    public static ErrorMessageFactory shouldHaveMutuallyComparableElements(Object actual) {
        return new ShouldBeSorted("\nsome elements are not mutually comparable in group:\n<%s>", actual);
    }

    public static ErrorMessageFactory shouldHaveComparableElementsAccordingToGivenComparator(Object actual, Comparator<?> comparator) {
        return new ShouldBeSorted("\nsome elements are not mutually comparable according to %s comparator in group:\n<%s>", comparator, actual);
    }

    private static List<?> groupAsList(Object group) {
        if (group.getClass().isArray()) {
            return ArrayWrapperList.wrap(group);
        }
        if (group instanceof Collection) {
            ArrayList asList = new ArrayList();
            asList.addAll((Collection)group);
            return asList;
        }
        throw new IllegalArgumentException("Parameter should be an array or a collection but was " + group);
    }
}

