/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAbsolutePath;
import org.assertj.core.error.ShouldBeDirectory;
import org.assertj.core.error.ShouldBeFile;
import org.assertj.core.error.ShouldBeReadable;
import org.assertj.core.error.ShouldBeRelativePath;
import org.assertj.core.error.ShouldBeWritable;
import org.assertj.core.error.ShouldExist;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveContent;
import org.assertj.core.error.ShouldHaveEqualContent;
import org.assertj.core.error.ShouldHaveExtension;
import org.assertj.core.error.ShouldHaveName;
import org.assertj.core.error.ShouldHaveNoParent;
import org.assertj.core.error.ShouldHaveParent;
import org.assertj.core.error.ShouldNotExist;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.FilesException;
import org.assertj.core.util.VisibleForTesting;

public class Files {
    private static final Files INSTANCE = new Files();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Files instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Files() {
    }

    public void assertEqualContent(AssertionInfo info, File actual, File expected) {
        this.verifyIsFile(expected);
        this.assertIsFile(info, actual);
        try {
            List<String> diffs = this.diff.diff(actual, expected);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveEqualContent.shouldHaveEqualContent(actual, expected, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to compare contents of files:<%s> and:<%s>", actual, expected);
            throw new FilesException(msg, e);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info, File actual, byte[] expected) {
        if (expected == null) {
            throw new NullPointerException("The binary content to compare to should not be null");
        }
        this.assertIsFile(info, actual);
        try {
            BinaryDiffResult result = this.binaryDiff.diff(actual, expected);
            if (result.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, result));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify binary contents of file:<%s>", actual);
            throw new FilesException(msg, e);
        }
    }

    public void assertHasContent(AssertionInfo info, File actual, String expected, Charset charset) {
        if (expected == null) {
            throw new NullPointerException("The text to compare to should not be null");
        }
        this.assertIsFile(info, actual);
        try {
            List<String> diffs = this.diff.diff(actual, expected, charset);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveContent.shouldHaveContent(actual, charset, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to verify text contents of file:<%s>", actual);
            throw new FilesException(msg, e);
        }
    }

    private void verifyIsFile(File expected) {
        if (expected == null) {
            throw new NullPointerException("The file to compare to should not be null");
        }
        if (expected.isFile()) {
            return;
        }
        throw new IllegalArgumentException(String.format("Expected file:<'%s'> should be an existing file", expected));
    }

    public void assertIsFile(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.isFile()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeFile.shouldBeFile(actual));
    }

    public void assertIsDirectory(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.isDirectory()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeDirectory.shouldBeDirectory(actual));
    }

    public void assertIsAbsolute(AssertionInfo info, File actual) {
        if (this.isAbsolutePath(info, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeAbsolutePath.shouldBeAbsolutePath(actual));
    }

    public void assertIsRelative(AssertionInfo info, File actual) {
        if (!this.isAbsolutePath(info, actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeRelativePath.shouldBeRelativePath(actual));
    }

    private boolean isAbsolutePath(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        return actual.isAbsolute();
    }

    public void assertExists(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.exists()) {
            return;
        }
        throw this.failures.failure(info, ShouldExist.shouldExist(actual));
    }

    public void assertDoesNotExist(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (!actual.exists()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotExist.shouldNotExist(actual));
    }

    public void assertCanWrite(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.canWrite()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeWritable.shouldBeWritable(actual));
    }

    public void assertCanRead(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.canRead()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeReadable.shouldBeReadable(actual));
    }

    public void assertHasParent(AssertionInfo info, File actual, File expected) {
        if (expected == null) {
            throw new NullPointerException("The expected parent file should not be null.");
        }
        Files.assertNotNull(info, actual);
        try {
            if (actual.getParentFile() != null && org.assertj.core.util.Objects.areEqual(expected.getCanonicalFile(), actual.getParentFile().getCanonicalFile())) {
                return;
            }
        }
        catch (IOException e) {
            throw new FilesException(String.format("Unable to get canonical form of [%s] or [%s].", actual, expected), e);
        }
        throw this.failures.failure(info, ShouldHaveParent.shouldHaveParent(actual, expected));
    }

    public void assertHasExtension(AssertionInfo info, File actual, String expected) {
        if (expected == null) {
            throw new NullPointerException("The expected extension should not be null.");
        }
        this.assertIsFile(info, actual);
        String actualExtension = this.getFileExtension(actual);
        if (expected.equals(actualExtension)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveExtension.shouldHaveExtension(actual, actualExtension, expected));
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int dotAt = name.lastIndexOf(46);
        return dotAt == -1 ? null : name.substring(dotAt + 1);
    }

    public void assertHasName(AssertionInfo info, File actual, String expected) {
        Files.assertNotNull(info, actual);
        if (expected == null) {
            throw new NullPointerException("The expected name should not be null.");
        }
        if (expected.equals(actual.getName())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveName.shouldHaveName(actual, expected));
    }

    private static void assertNotNull(AssertionInfo info, File actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    public void assertHasNoParent(AssertionInfo info, File actual) {
        Files.assertNotNull(info, actual);
        if (actual.getParentFile() == null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveNoParent.shouldHaveNoParent(actual));
    }
}

