/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractIterableSizeAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IterableSizeAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectEnumerableAssert;
import org.assertj.core.api.filter.FilterOperator;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.description.Description;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.IterableElementComparisonStrategy;
import org.assertj.core.internal.Iterables;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.internal.RecursiveFieldByFieldComparator;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;

public abstract class AbstractIterableAssert<SELF extends AbstractIterableAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractAssert<SELF, ACTUAL>
implements ObjectEnumerableAssert<SELF, ELEMENT> {
    private static final String ASSERT = "Assert";
    private Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames = new HashMap();
    private Map<Class<?>, Comparator<?>> comparatorsForElementPropertyOrFieldTypes = new HashMap();
    protected Iterables iterables = Iterables.instance();

    public AbstractIterableAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.iterables.assertNullOrEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public void isEmpty() {
        this.iterables.assertEmpty(this.info, (Iterable)this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.iterables.assertNotEmpty(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.iterables.assertHasSize(this.info, (Iterable)this.actual, expected);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Object other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.iterables.assertHasSameSizeAs((AssertionInfo)this.info, (Iterable)this.actual, other);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF contains(ELEMENT ... values) {
        this.iterables.assertContains(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsOnly(ELEMENT ... values) {
        this.iterables.assertContainsOnly(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsOnlyOnce(ELEMENT ... values) {
        this.iterables.assertContainsOnlyOnce(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsExactly(ELEMENT ... values) {
        this.iterables.assertContainsExactly(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsExactlyInAnyOrder(ELEMENT ... values) {
        this.iterables.assertContainsExactlyInAnyOrder(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF isSubsetOf(Iterable<? extends ELEMENT> values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF isSubsetOf(ELEMENT ... values) {
        this.iterables.assertIsSubsetOf(this.info, (Iterable)this.actual, java.util.Arrays.asList(values));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSequence(ELEMENT ... sequence) {
        this.iterables.assertContainsSequence(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsSubsequence(ELEMENT ... sequence) {
        this.iterables.assertContainsSubsequence(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContain(ELEMENT ... values) {
        this.iterables.assertDoesNotContain(this.info, (Iterable)this.actual, values);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainAnyElementsOf(Iterable<? extends ELEMENT> iterable) {
        this.iterables.assertDoesNotContainAnyElementsOf(this.info, (Iterable)this.actual, iterable);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        this.iterables.assertDoesNotHaveDuplicates(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF startsWith(ELEMENT ... sequence) {
        this.iterables.assertStartsWith(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF endsWith(ELEMENT ... sequence) {
        this.iterables.assertEndsWith(this.info, (Iterable)this.actual, sequence);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsNull() {
        this.iterables.assertContainsNull(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doesNotContainNull() {
        this.iterables.assertDoesNotContainNull(this.info, (Iterable)this.actual);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF are(Condition<? super ELEMENT> condition) {
        this.iterables.assertAre(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areNot(Condition<? super ELEMENT> condition) {
        this.iterables.assertAreNot(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF have(Condition<? super ELEMENT> condition) {
        this.iterables.assertHave(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF doNotHave(Condition<? super ELEMENT> condition) {
        this.iterables.assertDoNotHave(this.info, (Iterable)this.actual, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtLeastOne(Condition<? super ELEMENT> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areAtMost(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreAtMost(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF areExactly(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertAreExactly(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveAtLeastOne(Condition<? super ELEMENT> condition) {
        return (SELF)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public SELF haveAtLeast(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveAtLeast(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveAtMost(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveAtMost(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF haveExactly(int times, Condition<? super ELEMENT> condition) {
        this.iterables.assertHaveExactly(this.info, (Iterable)this.actual, times, condition);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasAtLeastOneElementOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasAtLeastOneElementOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF hasOnlyElementsOfType(Class<?> expectedType) {
        ObjectArrays.instance().assertHasOnlyElementsOfType(this.info, IterableUtil.toArray((Iterable)this.actual), expectedType);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF containsAll(Iterable<? extends ELEMENT> iterable) {
        this.iterables.assertContainsAll(this.info, (Iterable)this.actual, iterable);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF usingElementComparator(Comparator<? super ELEMENT> elementComparator) {
        this.iterables = new Iterables(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new IterableElementComparisonStrategy<ELEMENT>(elementComparator));
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    @Override
    public SELF usingDefaultElementComparator() {
        this.usingDefaultComparator();
        this.iterables = Iterables.instance();
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    public ListAssert<Object> extracting(String propertyOrField) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        return new ListAssert<Object>(values);
    }

    public ListAssert<Object> extractingResultOf(String method) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extractingResultOf(String method, Class<P> extractedType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.resultOf(method));
        return new ListAssert<Object>(values);
    }

    public <P> ListAssert<P> extracting(String propertyOrField, Class<P> extractingType) {
        List<Object> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertyOrField));
        return new ListAssert<Object>(values);
    }

    public ListAssert<Tuple> extracting(String ... propertiesOrFields) {
        List<Tuple> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(propertiesOrFields));
        return new ListAssert<Tuple>(values);
    }

    public <V> ListAssert<V> extracting(Extractor<? super ELEMENT, V> extractor) {
        List<V> values = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        return new ListAssert<V>(values);
    }

    public <V> ListAssert<V> flatExtracting(Extractor<? super ELEMENT, ? extends Collection<V>> extractor) {
        ArrayList result = Lists.newArrayList();
        List<Collection<V>> extractedValues = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, extractor);
        for (Collection<V> iterable : extractedValues) {
            result.addAll(iterable);
        }
        return new ListAssert(result);
    }

    public ListAssert<Object> flatExtracting(String fieldOrPropertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(fieldOrPropertyName));
        for (Object group : extractedGroups) {
            if (Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return new ListAssert<Object>(extractedValues);
    }

    public ListAssert<Object> flatExtracting(String ... fieldOrPropertyNames) {
        ArrayList extractedValues = Lists.newArrayList();
        for (Tuple tuple : FieldsOrPropertiesExtractor.extract((Iterable)this.actual, Extractors.byName(fieldOrPropertyNames))) {
            extractedValues.addAll(tuple.toList());
        }
        return new ListAssert<Object>(extractedValues);
    }

    @Override
    public SELF containsExactlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF containsOnlyElementsOf(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public SELF hasSameElementsAs(Iterable<? extends ELEMENT> iterable) {
        return (SELF)this.containsOnlyElementsOf((Iterable)iterable);
    }

    public <T> SELF usingComparatorForElementFieldsWithNames(Comparator<T> comparator, String ... elementPropertyOrFieldNames) {
        for (String elementPropertyOrField : elementPropertyOrFieldNames) {
            this.comparatorsForElementPropertyOrFieldNames.put(elementPropertyOrField, comparator);
        }
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    public <T> SELF usingComparatorForElementFieldsWithType(Comparator<T> comparator, Class<T> type) {
        this.comparatorsForElementPropertyOrFieldTypes.put(type, comparator);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    public SELF usingFieldByFieldElementComparator() {
        return (SELF)this.usingElementComparator((Comparator)new FieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    public SELF usingRecursiveFieldByFieldElementComparator() {
        return (SELF)this.usingElementComparator((Comparator)new RecursiveFieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    public SELF usingElementComparatorOnFields(String ... fields) {
        return (SELF)this.usingElementComparator((Comparator)new OnFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    protected SELF usingComparisonStrategy(ComparisonStrategy comparisonStrategy) {
        this.iterables = new Iterables(comparisonStrategy);
        return (SELF)((AbstractIterableAssert)this.myself);
    }

    public SELF usingElementComparatorIgnoringFields(String ... fields) {
        return (SELF)this.usingElementComparator((Comparator)new IgnoringFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    @Override
    public SELF inHexadecimal() {
        return (SELF)((AbstractIterableAssert)super.inHexadecimal());
    }

    @Override
    public SELF inBinary() {
        return (SELF)((AbstractIterableAssert)super.inBinary());
    }

    public SELF filteredOn(String propertyOrFieldName, Object expectedValue) {
        Filters filter = Filters.filter((Iterable)this.actual);
        Iterable filteredIterable = filter.with(propertyOrFieldName, expectedValue).get();
        return (SELF)new ListAssert(Lists.newArrayList(filteredIterable));
    }

    public SELF filteredOnNull(String propertyOrFieldName) {
        return this.filteredOn(propertyOrFieldName, (Object)null);
    }

    public SELF filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters filter = Filters.filter((Iterable)this.actual).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return (SELF)new ListAssert(Lists.newArrayList(filter.get()));
    }

    public SELF filteredOn(Condition<? super ELEMENT> condition) {
        Filters<? super ELEMENT> filter = Filters.filter((Iterable)this.actual);
        Iterable<? super ELEMENT> filteredIterable = filter.being(condition).get();
        return (SELF)new ListAssert<ELEMENT>(Lists.newArrayList(filteredIterable));
    }

    public ELEMENT_ASSERT first() {
        this.isNotEmpty();
        return this.toAssert(((Iterable)this.actual).iterator().next(), this.navigationDescription("check first element"));
    }

    public ELEMENT_ASSERT last() {
        this.isNotEmpty();
        return this.toAssert(this.lastElement(), this.navigationDescription("check last element"));
    }

    private ELEMENT lastElement() {
        if (this.actual instanceof List) {
            List list = (List)this.actual;
            return (ELEMENT)list.get(list.size() - 1);
        }
        Iterator actualIterator = ((Iterable)this.actual).iterator();
        Object last = actualIterator.next();
        while (actualIterator.hasNext()) {
            last = actualIterator.next();
        }
        return (ELEMENT)last;
    }

    public ELEMENT_ASSERT element(int index) {
        this.isNotEmpty();
        ((AbstractIntegerAssert)Assertions.assertThat(index).describedAs(this.navigationDescription("check index validity"), new Object[0])).isBetween(0, IterableUtil.sizeOf((Iterable)this.actual) - 1);
        ELEMENT elementAtIndex = null;
        if (this.actual instanceof List) {
            List list = (List)this.actual;
            elementAtIndex = (ELEMENT)list.get(index);
        } else {
            Iterator actualIterator = ((Iterable)this.actual).iterator();
            for (int i = 0; i < index; ++i) {
                actualIterator.next();
            }
            elementAtIndex = (ELEMENT)actualIterator.next();
        }
        return this.toAssert(elementAtIndex, this.navigationDescription("element at index " + index));
    }

    protected abstract ELEMENT_ASSERT toAssert(ELEMENT var1, String var2);

    protected String navigationDescription(String propertyName) {
        String text = this.descriptionText();
        if (Strings.isNullOrEmpty(text)) {
            text = AbstractIterableAssert.removeAssert(this.getClass().getSimpleName());
        }
        return text + " " + propertyName;
    }

    private static String removeAssert(String text) {
        return text.endsWith(ASSERT) ? text.substring(0, text.length() - ASSERT.length()) : text;
    }

    @Override
    public SELF as(String description, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.as(description, args));
    }

    @Override
    public SELF as(Description description) {
        return (SELF)((AbstractIterableAssert)super.as(description));
    }

    @Override
    public SELF describedAs(Description description) {
        return (SELF)((AbstractIterableAssert)super.describedAs(description));
    }

    @Override
    public SELF describedAs(String description, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.describedAs(description, args));
    }

    @Override
    public SELF doesNotHave(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.doesNotHave(condition));
    }

    @Override
    public SELF doesNotHaveSameClassAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public SELF has(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.has(condition));
    }

    @Override
    public SELF hasSameClassAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.hasSameClassAs(other));
    }

    @Override
    public SELF hasToString(String expectedToString) {
        return (SELF)((AbstractIterableAssert)super.hasToString(expectedToString));
    }

    @Override
    public SELF is(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.is(condition));
    }

    @Override
    public SELF isEqualTo(Object expected) {
        return (SELF)((AbstractIterableAssert)super.isEqualTo(expected));
    }

    @Override
    public SELF isExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isIn(Iterable<?> values) {
        return (SELF)((AbstractIterableAssert)super.isIn((Iterable)values));
    }

    @Override
    public SELF isIn(Object ... values) {
        return (SELF)((AbstractIterableAssert)super.isIn(values));
    }

    @Override
    public SELF isInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isInstanceOf((Class)type));
    }

    @Override
    public SELF isInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNot(Condition<? super ACTUAL> condition) {
        return (SELF)((AbstractIterableAssert)super.isNot(condition));
    }

    @Override
    public SELF isNotEqualTo(Object other) {
        return (SELF)((AbstractIterableAssert)super.isNotEqualTo(other));
    }

    @Override
    public SELF isNotExactlyInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isNotExactlyInstanceOf((Class)type));
    }

    @Override
    public SELF isNotIn(Iterable<?> values) {
        return (SELF)((AbstractIterableAssert)super.isNotIn((Iterable)values));
    }

    @Override
    public SELF isNotIn(Object ... values) {
        return (SELF)((AbstractIterableAssert)super.isNotIn(values));
    }

    @Override
    public SELF isNotInstanceOf(Class<?> type) {
        return (SELF)((AbstractIterableAssert)super.isNotInstanceOf((Class)type));
    }

    @Override
    public SELF isNotInstanceOfAny(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public SELF isNotOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isNotNull() {
        return (SELF)((AbstractIterableAssert)super.isNotNull());
    }

    @Override
    public SELF isNotSameAs(Object other) {
        return (SELF)((AbstractIterableAssert)super.isNotSameAs(other));
    }

    @Override
    public SELF isOfAnyClassIn(Class<?> ... types) {
        return (SELF)((AbstractIterableAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public SELF isSameAs(Object expected) {
        return (SELF)((AbstractIterableAssert)super.isSameAs(expected));
    }

    @Override
    public SELF overridingErrorMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.overridingErrorMessage(newErrorMessage, args));
    }

    @Override
    public SELF usingDefaultComparator() {
        return (SELF)((AbstractIterableAssert)super.usingDefaultComparator());
    }

    @Override
    public SELF usingComparator(Comparator<? super ACTUAL> customComparator) {
        return (SELF)((AbstractIterableAssert)super.usingComparator(customComparator));
    }

    @Override
    public SELF withFailMessage(String newErrorMessage, Object ... args) {
        return (SELF)((AbstractIterableAssert)super.withFailMessage(newErrorMessage, args));
    }

    @Override
    public SELF withThreadDumpOnError() {
        return (SELF)((AbstractIterableAssert)super.withThreadDumpOnError());
    }

    public AbstractIterableSizeAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT> size() {
        Preconditions.checkNotNull(this.actual, "Can not perform assertions on the size of a null iterable.");
        return new IterableSizeAssert(this, IterableUtil.sizeOf((Iterable)this.actual));
    }
}

