/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.DeepDifference;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;

public class ShouldBeEqualByComparingFieldByFieldRecursively
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeEqualByComparingFieldByFieldRecursive(Object actual, Object other, List<DeepDifference.Difference> differences, Representation representation) {
        List descriptionOfDifferences = differences.stream().map(difference -> ShouldBeEqualByComparingFieldByFieldRecursively.describeDifference(difference, representation)).collect(Collectors.toList());
        return new ShouldBeEqualByComparingFieldByFieldRecursively("%nExpecting:%n  <%s>%nto be equal to:%n  <%s>%nwhen recursively comparing field by field, but found the following difference(s):%n" + Strings.join(descriptionOfDifferences).with(String.format("%n", new Object[0])), actual, other);
    }

    private ShouldBeEqualByComparingFieldByFieldRecursively(String message, Object actual, Object other) {
        super(message, actual, other);
    }

    private static String describeDifference(DeepDifference.Difference difference, Representation representation) {
        String otherFieldValue;
        String actualFieldValue = representation.toStringOf(difference.getActual());
        boolean sameRepresentation = Objects.areEqual(actualFieldValue, otherFieldValue = representation.toStringOf(difference.getOther()));
        String actualFieldValueRepresentation = sameRepresentation ? representation.unambiguousToStringOf(difference.getActual()) : actualFieldValue;
        String otherFieldValueRepresentation = sameRepresentation ? representation.unambiguousToStringOf(difference.getOther()) : otherFieldValue;
        String additionalInfo = difference.getDescription().map(desc -> String.format("%n- reason  : %s", Strings.escapePercent(desc))).orElse("");
        return String.format("%nPath to difference: <%s>%n- actual  : <%s>%n- expected: <%s>" + additionalInfo, Strings.join(difference.getPath()).with("."), Strings.escapePercent(actualFieldValueRepresentation), Strings.escapePercent(otherFieldValueRepresentation));
    }
}

