/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.assertj.core.internal.bytebuddy.build.CachedReturnPlugin;
import org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.dynamic.ClassFileLocator;
import org.assertj.core.internal.bytebuddy.jar.asm.ClassReader;
import org.assertj.core.internal.bytebuddy.jar.asm.ClassVisitor;
import org.assertj.core.internal.bytebuddy.utility.OpenedClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class ClassFileVersion
implements Comparable<ClassFileVersion> {
    protected static final int BASE_VERSION = 44;
    public static final ClassFileVersion JAVA_V1 = new ClassFileVersion(196653);
    public static final ClassFileVersion JAVA_V2 = new ClassFileVersion(46);
    public static final ClassFileVersion JAVA_V3 = new ClassFileVersion(47);
    public static final ClassFileVersion JAVA_V4 = new ClassFileVersion(48);
    public static final ClassFileVersion JAVA_V5 = new ClassFileVersion(49);
    public static final ClassFileVersion JAVA_V6 = new ClassFileVersion(50);
    public static final ClassFileVersion JAVA_V7 = new ClassFileVersion(51);
    public static final ClassFileVersion JAVA_V8 = new ClassFileVersion(52);
    public static final ClassFileVersion JAVA_V9 = new ClassFileVersion(53);
    public static final ClassFileVersion JAVA_V10 = new ClassFileVersion(54);
    public static final ClassFileVersion JAVA_V11 = new ClassFileVersion(55);
    public static final ClassFileVersion JAVA_V12 = new ClassFileVersion(56);
    public static final ClassFileVersion JAVA_V13 = new ClassFileVersion(57);
    public static final ClassFileVersion JAVA_V14 = new ClassFileVersion(58);
    private static final VersionLocator VERSION_LOCATOR = AccessController.doPrivileged(VersionLocator.CreationAction.INSTANCE);
    private final int versionNumber;
    private static transient /* synthetic */ ClassFileVersion ofThisVm_U6dUl4CU;

    protected ClassFileVersion(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public static ClassFileVersion ofMinorMajor(int versionNumber) {
        ClassFileVersion classFileVersion = new ClassFileVersion(versionNumber);
        if (classFileVersion.getMajorVersion() <= 44) {
            throw new IllegalArgumentException("Class version " + versionNumber + " is not valid");
        }
        return classFileVersion;
    }

    public static ClassFileVersion ofJavaVersionString(String javaVersionString) {
        if (javaVersionString.equals("1.1")) {
            return JAVA_V1;
        }
        if (javaVersionString.equals("1.2")) {
            return JAVA_V2;
        }
        if (javaVersionString.equals("1.3")) {
            return JAVA_V3;
        }
        if (javaVersionString.equals("1.4")) {
            return JAVA_V4;
        }
        if (javaVersionString.equals("1.5") || javaVersionString.equals("5")) {
            return JAVA_V5;
        }
        if (javaVersionString.equals("1.6") || javaVersionString.equals("6")) {
            return JAVA_V6;
        }
        if (javaVersionString.equals("1.7") || javaVersionString.equals("7")) {
            return JAVA_V7;
        }
        if (javaVersionString.equals("1.8") || javaVersionString.equals("8")) {
            return JAVA_V8;
        }
        if (javaVersionString.equals("1.9") || javaVersionString.equals("9")) {
            return JAVA_V9;
        }
        if (javaVersionString.equals("1.10") || javaVersionString.equals("10")) {
            return JAVA_V10;
        }
        if (javaVersionString.equals("1.11") || javaVersionString.equals("11")) {
            return JAVA_V11;
        }
        if (javaVersionString.equals("1.12") || javaVersionString.equals("12")) {
            return JAVA_V12;
        }
        if (javaVersionString.equals("1.13") || javaVersionString.equals("13")) {
            return JAVA_V13;
        }
        if (javaVersionString.equals("1.14") || javaVersionString.equals("14")) {
            return JAVA_V14;
        }
        if (OpenedClassReader.EXPERIMENTAL) {
            try {
                int version = Integer.parseInt(javaVersionString.startsWith("1.") ? javaVersionString.substring(2) : javaVersionString);
                if (version > 0) {
                    return new ClassFileVersion(44 + version);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Unknown Java version string: " + javaVersionString);
    }

    public static ClassFileVersion ofJavaVersion(int javaVersion) {
        switch (javaVersion) {
            case 1: {
                return JAVA_V1;
            }
            case 2: {
                return JAVA_V2;
            }
            case 3: {
                return JAVA_V3;
            }
            case 4: {
                return JAVA_V4;
            }
            case 5: {
                return JAVA_V5;
            }
            case 6: {
                return JAVA_V6;
            }
            case 7: {
                return JAVA_V7;
            }
            case 8: {
                return JAVA_V8;
            }
            case 9: {
                return JAVA_V9;
            }
            case 10: {
                return JAVA_V10;
            }
            case 11: {
                return JAVA_V11;
            }
            case 12: {
                return JAVA_V12;
            }
            case 13: {
                return JAVA_V13;
            }
            case 14: {
                return JAVA_V14;
            }
        }
        if (OpenedClassReader.EXPERIMENTAL && javaVersion > 0) {
            return new ClassFileVersion(44 + javaVersion);
        }
        throw new IllegalArgumentException("Unknown Java version: " + javaVersion);
    }

    @CachedReturnPlugin.Enhance
    public static ClassFileVersion ofThisVm() {
        ClassFileVersion classFileVersion;
        ClassFileVersion classFileVersion2 = ofThisVm_U6dUl4CU;
        ClassFileVersion classFileVersion3 = classFileVersion = classFileVersion2 != null ? null : VERSION_LOCATOR.locate();
        if (classFileVersion == null) {
            classFileVersion = ofThisVm_U6dUl4CU;
        } else {
            ofThisVm_U6dUl4CU = classFileVersion;
        }
        return classFileVersion;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
    public static ClassFileVersion ofThisVm(ClassFileVersion fallback) {
        try {
            return ClassFileVersion.ofThisVm();
        }
        catch (Exception ignored) {
            return fallback;
        }
    }

    public static ClassFileVersion of(Class<?> type) throws IOException {
        return ClassFileVersion.of(type, ClassFileLocator.ForClassLoader.of(type.getClassLoader()));
    }

    public static ClassFileVersion of(Class<?> type, ClassFileLocator classFileLocator) throws IOException {
        return ClassFileVersion.of(TypeDescription.ForLoadedType.of(type), classFileLocator);
    }

    public static ClassFileVersion of(TypeDescription typeDescription, ClassFileLocator classFileLocator) throws IOException {
        ClassReader classReader = OpenedClassReader.of(classFileLocator.locate(typeDescription.getName()).resolve());
        VersionExtractor versionExtractor = new VersionExtractor();
        classReader.accept(versionExtractor, 1);
        return ClassFileVersion.ofMinorMajor(versionExtractor.getClassFileVersionNumber());
    }

    public int getMinorMajorVersion() {
        return this.versionNumber;
    }

    public int getMajorVersion() {
        return this.versionNumber & 0xFF;
    }

    public int getMinorVersion() {
        return this.versionNumber >> 16;
    }

    public int getJavaVersion() {
        return this.getMajorVersion() - 44;
    }

    public boolean isAtLeast(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) > -1;
    }

    public boolean isGreaterThan(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) > 0;
    }

    public boolean isAtMost(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) < 1;
    }

    public boolean isLessThan(ClassFileVersion classFileVersion) {
        return this.compareTo(classFileVersion) < 0;
    }

    public ClassFileVersion asPreviewVersion() {
        return new ClassFileVersion(this.versionNumber | 0xFFFF0000);
    }

    public boolean isPreviewVersion() {
        return (this.versionNumber & 0xFFFF0000) == -65536;
    }

    @Override
    public int compareTo(ClassFileVersion other) {
        return Integer.signum(this.getMajorVersion() == other.getMajorVersion() ? this.getMinorVersion() - other.getMinorVersion() : this.getMajorVersion() - other.getMajorVersion());
    }

    public String toString() {
        return "Java " + this.getJavaVersion();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.versionNumber == ((ClassFileVersion)object).versionNumber;
    }

    public int hashCode() {
        return 17 * 31 + this.versionNumber;
    }

    protected static class VersionExtractor
    extends ClassVisitor {
        private int classFileVersionNumber;

        protected VersionExtractor() {
            super(OpenedClassReader.ASM_API);
        }

        public void visit(int classFileVersionNumber, int modifier, String internalName, String signature, String superTypeName, String[] interfaceName) {
            this.classFileVersionNumber = classFileVersionNumber;
        }

        protected int getClassFileVersionNumber() {
            return this.classFileVersionNumber;
        }
    }

    protected static interface VersionLocator {
        public ClassFileVersion locate();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForLegacyVm implements VersionLocator,
        PrivilegedAction<String>
        {
            INSTANCE;

            private static final String JAVA_VERSION_PROPERTY = "java.version";

            @Override
            public ClassFileVersion locate() {
                String versionString = AccessController.doPrivileged(this);
                int[] versionIndex = new int[]{-1, 0, 0};
                for (int i = 1; i < 3; ++i) {
                    versionIndex[i] = versionString.indexOf(46, versionIndex[i - 1] + 1);
                    if (versionIndex[i] != -1) continue;
                    throw new IllegalStateException("This JVM's version string does not seem to be valid: " + versionString);
                }
                return ClassFileVersion.ofJavaVersion(Integer.parseInt(versionString.substring(versionIndex[1] + 1, versionIndex[2])));
            }

            @Override
            public String run() {
                return System.getProperty(JAVA_VERSION_PROPERTY);
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForJava9CapableVm
        implements VersionLocator {
            private static final Object STATIC_METHOD = null;
            private final Method current;
            private final Method major;

            protected ForJava9CapableVm(Method current, Method major) {
                this.current = current;
                this.major = major;
            }

            public ClassFileVersion locate() {
                try {
                    return ClassFileVersion.ofJavaVersion((Integer)this.major.invoke(this.current.invoke(STATIC_METHOD, new Object[0]), new Object[0]));
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Could not access VM version lookup", exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Could not look up VM version", exception.getCause());
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.current.equals(((ForJava9CapableVm)object).current)) {
                    return false;
                }
                return this.major.equals(((ForJava9CapableVm)object).major);
            }

            public int hashCode() {
                return (17 * 31 + this.current.hashCode()) * 31 + this.major.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CreationAction implements PrivilegedAction<VersionLocator>
        {
            INSTANCE;


            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
            public VersionLocator run() {
                try {
                    return new ForJava9CapableVm(Runtime.class.getMethod("version", new Class[0]), Class.forName("java.lang.Runtime$Version").getMethod("major", new Class[0]));
                }
                catch (Exception ignored) {
                    return ForLegacyVm.INSTANCE;
                }
            }
        }
    }
}

