/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectAssertFactory;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.util.Streams;

public class IterableAssert<ELEMENT>
extends FactoryBasedNavigableIterableAssert<IterableAssert<ELEMENT>, Iterable<? extends ELEMENT>, ELEMENT, ObjectAssert<ELEMENT>> {
    public IterableAssert(Iterable<? extends ELEMENT> actual) {
        super(actual, IterableAssert.class, new ObjectAssertFactory());
    }

    @Override
    protected IterableAssert<ELEMENT> newAbstractIterableAssert(Iterable<? extends ELEMENT> iterable) {
        return new IterableAssert<ELEMENT>(iterable);
    }

    static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        return Streams.stream(iterator).collect(Collectors.toList());
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> contains(ELEMENT ... values) {
        return (IterableAssert)super.contains((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsOnly(ELEMENT ... values) {
        return (IterableAssert)super.containsOnly((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsOnlyOnce(ELEMENT ... values) {
        return (IterableAssert)super.containsOnlyOnce((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsExactly(ELEMENT ... values) {
        return (IterableAssert)super.containsExactly((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsExactlyInAnyOrder(ELEMENT ... values) {
        return (IterableAssert)super.containsExactlyInAnyOrder((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsAnyOf(ELEMENT ... values) {
        return (IterableAssert)super.containsAnyOf((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> isSubsetOf(ELEMENT ... values) {
        return (IterableAssert)super.isSubsetOf((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsSequence(ELEMENT ... sequence) {
        return (IterableAssert)super.containsSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContainSequence(ELEMENT ... sequence) {
        return (IterableAssert)super.doesNotContainSequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> containsSubsequence(ELEMENT ... sequence) {
        return (IterableAssert)super.containsSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContainSubsequence(ELEMENT ... sequence) {
        return (IterableAssert)super.doesNotContainSubsequence((Object[])sequence);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> doesNotContain(ELEMENT ... values) {
        return (IterableAssert)super.doesNotContain((Object[])values);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> endsWith(ELEMENT first, ELEMENT ... rest) {
        return (IterableAssert)super.endsWith((Object)first, (Object[])rest);
    }

    @Override
    @SafeVarargs
    public final <EXCEPTION extends Exception> AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> flatExtracting(ThrowingExtractor<? super ELEMENT, ?, EXCEPTION> ... extractors) {
        return super.flatExtracting(extractors);
    }

    @Override
    @SafeVarargs
    public final <EXCEPTION extends Exception> AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatMap(ThrowingExtractor<? super ELEMENT, ?, EXCEPTION> ... mappers) {
        return super.flatMap(mappers);
    }

    @Override
    @SafeVarargs
    public final AbstractListAssert<?, List<?>, Object, ObjectAssert<Object>> flatExtracting(Function<? super ELEMENT, ?> ... extractors) {
        return super.flatExtracting(extractors);
    }

    @Override
    @SafeVarargs
    public final AbstractListAssert<?, List<? extends Object>, Object, ObjectAssert<Object>> flatMap(Function<? super ELEMENT, ?> ... mappers) {
        return super.flatMap(mappers);
    }

    @Override
    @SafeVarargs
    public final AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> extracting(Function<? super ELEMENT, ?> ... extractors) {
        return super.extracting(extractors);
    }

    @Override
    @SafeVarargs
    public final AbstractListAssert<?, List<? extends Tuple>, Tuple, ObjectAssert<Tuple>> map(Function<? super ELEMENT, ?> ... mappers) {
        return super.extracting(mappers);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> satisfiesExactly(Consumer<? super ELEMENT> ... requirements) {
        return (IterableAssert)super.satisfiesExactly((Consumer[])requirements);
    }

    @Override
    @SafeVarargs
    public final IterableAssert<ELEMENT> satisfiesExactlyInAnyOrder(Consumer<? super ELEMENT> ... requirements) {
        return (IterableAssert)super.satisfiesExactlyInAnyOrder((Consumer[])requirements);
    }
}

