/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.data.MapEntry;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Closeables;
import org.assertj.core.util.DateUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Streams;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.ChangeDelta;
import org.assertj.core.util.diff.DeleteDelta;
import org.assertj.core.util.diff.InsertDelta;

public class StandardRepresentation
implements Representation {
    private static final String NULL = "null";
    public static final StandardRepresentation STANDARD_REPRESENTATION = new StandardRepresentation();
    private static final String TUPLE_START = "(";
    private static final String TUPLE_END = ")";
    private static final String DEFAULT_START = "[";
    private static final String DEFAULT_END = "]";
    private static final String DEFAULT_MAX_ELEMENTS_EXCEEDED = "...";
    static final String INDENTATION_AFTER_NEWLINE = "    ";
    static final String INDENTATION_FOR_SINGLE_LINE = " ";
    public static final String ELEMENT_SEPARATOR = ",";
    public static final String ELEMENT_SEPARATOR_WITH_NEWLINE = "," + System.lineSeparator();
    private static int maxLengthForSingleLineDescription = 80;
    private static int maxElementsForPrinting = 1000;
    private static int maxStackTraceElementsDisplayed = 3;
    private static final Map<Class<?>, Function<?, String>> customFormatterByType = new HashMap();
    private static final Class<?>[] TYPE_WITH_UNAMBIGUOUS_REPRESENTATION = new Class[]{Date.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, Calendar.class};

    public static void resetDefaults() {
        maxLengthForSingleLineDescription = 80;
        maxElementsForPrinting = 1000;
    }

    public static void setMaxLengthForSingleLineDescription(int value) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Preconditions.checkArgument(value > 0, "maxLengthForSingleLineDescription must be > 0 but was %s", value);
        maxLengthForSingleLineDescription = value;
    }

    @VisibleForTesting
    public static int getMaxLengthForSingleLineDescription() {
        return maxLengthForSingleLineDescription;
    }

    public static void setMaxElementsForPrinting(int value) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Preconditions.checkArgument(value >= 1, "maxElementsForPrinting must be >= 1, but was %s", value);
        maxElementsForPrinting = value;
    }

    @VisibleForTesting
    public static int getMaxStackTraceElementsDisplayed() {
        return maxStackTraceElementsDisplayed;
    }

    public static void setMaxStackTraceElementsDisplayed(int value) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Preconditions.checkArgument(value >= 0, "maxStackTraceElementsDisplayed  must be >= 0, but was %s", value);
        maxStackTraceElementsDisplayed = value;
    }

    @VisibleForTesting
    public static int getMaxElementsForPrinting() {
        return maxElementsForPrinting;
    }

    public static <T> void registerFormatterForType(Class<T> type, Function<T, String> formatter) {
        customFormatterByType.put(type, formatter);
    }

    public static void removeAllRegisteredFormatters() {
        customFormatterByType.clear();
    }

    @Override
    public String toStringOf(Object object) {
        if (object == null) {
            return null;
        }
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof ComparatorBasedComparisonStrategy) {
            return this.toStringOf((ComparatorBasedComparisonStrategy)object);
        }
        if (object instanceof Calendar) {
            return this.toStringOf((Calendar)object);
        }
        if (object instanceof Class) {
            return this.toStringOf((Class)object);
        }
        if (object instanceof Date) {
            return this.toStringOf((Date)object);
        }
        if (object instanceof Duration) {
            return this.toStringOf((Duration)object);
        }
        if (object instanceof LocalDate) {
            return this.toStringOf((LocalDate)object);
        }
        if (object instanceof LocalDateTime) {
            return this.toStringOf((LocalDateTime)object);
        }
        if (object instanceof OffsetDateTime) {
            return this.toStringOf((OffsetDateTime)object);
        }
        if (object instanceof ZonedDateTime) {
            return this.toStringOf((ZonedDateTime)object);
        }
        if (object instanceof LongAdder) {
            return this.toStringOf((LongAdder)object);
        }
        if (StandardRepresentation.isInstanceOfNotOverridingToString(object, AtomicReference.class)) {
            return this.toStringOf((AtomicReference)object);
        }
        if (StandardRepresentation.isInstanceOfNotOverridingToString(object, AtomicMarkableReference.class)) {
            return this.toStringOf((AtomicMarkableReference)object);
        }
        if (StandardRepresentation.isInstanceOfNotOverridingToString(object, AtomicStampedReference.class)) {
            return this.toStringOf((AtomicStampedReference)object);
        }
        if (object instanceof AtomicIntegerFieldUpdater) {
            return AtomicIntegerFieldUpdater.class.getSimpleName();
        }
        if (object instanceof AtomicLongFieldUpdater) {
            return AtomicLongFieldUpdater.class.getSimpleName();
        }
        if (object instanceof AtomicReferenceFieldUpdater) {
            return AtomicReferenceFieldUpdater.class.getSimpleName();
        }
        if (object instanceof File) {
            return this.toStringOf((File)object);
        }
        if (object instanceof Path) {
            return this.fallbackToStringOf(object);
        }
        if (object instanceof String) {
            return this.toStringOf((String)object);
        }
        if (object instanceof Character) {
            return this.toStringOf((Character)object);
        }
        if (object instanceof Comparator) {
            return this.toStringOf((Comparator)object);
        }
        if (object instanceof SimpleDateFormat) {
            return this.toStringOf((SimpleDateFormat)object);
        }
        if (object instanceof PredicateDescription) {
            return this.toStringOf((PredicateDescription)object);
        }
        if (object instanceof Future) {
            return this.toStringOf((Future)object);
        }
        if (Arrays.isArray(object)) {
            return this.formatArray(object);
        }
        if (object instanceof Collection) {
            return this.smartFormat((Collection)object);
        }
        if (object instanceof Map) {
            return this.toStringOf((Map)object);
        }
        if (object instanceof Tuple) {
            return this.toStringOf((Tuple)object);
        }
        if (object instanceof MapEntry) {
            return this.toStringOf((MapEntry)object);
        }
        if (object instanceof Method) {
            return ((Method)object).toGenericString();
        }
        if (object instanceof InsertDelta) {
            return this.toStringOf((InsertDelta)object);
        }
        if (object instanceof ChangeDelta) {
            return this.toStringOf((ChangeDelta)object);
        }
        if (object instanceof DeleteDelta) {
            return this.toStringOf((DeleteDelta)object);
        }
        if (object instanceof Iterable && !StandardRepresentation.hasOverriddenToString(object.getClass())) {
            return this.smartFormat((Iterable)object);
        }
        if (object instanceof AtomicInteger) {
            return this.toStringOf((AtomicInteger)object);
        }
        if (object instanceof AtomicBoolean) {
            return this.toStringOf((AtomicBoolean)object);
        }
        if (object instanceof AtomicLong) {
            return this.toStringOf((AtomicLong)object);
        }
        if (object instanceof Number) {
            return this.toStringOf((Number)object);
        }
        if (object instanceof Throwable) {
            return this.toStringOf((Throwable)object);
        }
        return this.fallbackToStringOf(object);
    }

    private static boolean isInstanceOfNotOverridingToString(Object object, Class<?> type) {
        return type.isInstance(object) && !StandardRepresentation.hasOverriddenToStringInSubclassOf(object.getClass(), type);
    }

    private static boolean hasOverriddenToString(Class<?> clazz) {
        try {
            Class<?> classDeclaringToString = clazz.getMethod("toString", new Class[0]).getDeclaringClass();
            return !Object.class.equals(classDeclaringToString);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    private static boolean hasOverriddenToStringInSubclassOf(Class<?> objectClass, Class<?> clazz) {
        try {
            Class<?> classDeclaringToString = objectClass.getMethod("toString", new Class[0]).getDeclaringClass();
            Class<?> classToCheck = objectClass;
            while (!classToCheck.equals(clazz)) {
                if (classDeclaringToString.equals(classToCheck)) {
                    return true;
                }
                classToCheck = classToCheck.getSuperclass();
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String unambiguousToStringOf(Object obj) {
        if (this.hasAlreadyAnUnambiguousToStringOf(obj)) {
            return this.toStringOf(obj);
        }
        return obj == null ? null : String.format("%s (%s@%s)", this.toStringOf(obj), StandardRepresentation.classNameOf(obj), StandardRepresentation.identityHexCodeOf(obj));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected <T> String customFormat(T object) {
        if (object == null) {
            return null;
        }
        return customFormatterByType.get(object.getClass()).apply(object);
    }

    protected boolean hasCustomFormatterFor(Object object) {
        if (object == null) {
            return false;
        }
        return customFormatterByType.containsKey(object.getClass());
    }

    protected boolean hasAlreadyAnUnambiguousToStringOf(Object obj) {
        for (int i = 0; i < TYPE_WITH_UNAMBIGUOUS_REPRESENTATION.length; ++i) {
            if (!TYPE_WITH_UNAMBIGUOUS_REPRESENTATION[i].isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    protected String fallbackToStringOf(Object object) {
        return object.toString();
    }

    protected String toStringOf(Number number) {
        if (number instanceof Float) {
            return this.toStringOf((Float)number);
        }
        if (number instanceof Long) {
            return this.toStringOf((Long)number);
        }
        return number.toString();
    }

    protected String toStringOf(AtomicBoolean atomicBoolean) {
        return String.format("AtomicBoolean(%s)", atomicBoolean.get());
    }

    protected String toStringOf(AtomicInteger atomicInteger) {
        return String.format("AtomicInteger(%s)", atomicInteger.get());
    }

    protected String toStringOf(AtomicLong atomicLong) {
        return String.format("AtomicLong(%s)", atomicLong.get());
    }

    protected String toStringOf(LongAdder longAdder) {
        return String.format("LongAdder(%s)", longAdder.sum());
    }

    protected String toStringOf(Comparator<?> comparator) {
        if (!comparator.toString().contains("@")) {
            return comparator.toString();
        }
        String comparatorSimpleClassName = comparator.getClass().getSimpleName();
        if (comparatorSimpleClassName.length() == 0) {
            return Strings.quote("anonymous comparator class");
        }
        if (comparator.toString().contains(comparatorSimpleClassName + "@")) {
            return comparatorSimpleClassName;
        }
        return comparator.toString();
    }

    protected String toStringOf(ComparatorBasedComparisonStrategy comparatorBasedComparisonStrategy) {
        String comparatorDescription = comparatorBasedComparisonStrategy.getComparatorDescription();
        return comparatorDescription == null ? this.toStringOf(comparatorBasedComparisonStrategy.getComparator()) : Strings.quote(comparatorDescription);
    }

    protected String toStringOf(Calendar calendar) {
        return DateUtil.formatAsDatetime(calendar) + this.classNameDisambiguation(calendar);
    }

    protected String toStringOf(Class<?> c) {
        return c.getCanonicalName();
    }

    protected String toStringOf(String s) {
        return Strings.concat("\"", s, "\"");
    }

    protected String toStringOf(Character c) {
        return Strings.concat("'", c, "'");
    }

    protected String toStringOf(PredicateDescription p) {
        return p.isDefault() ? String.format("%s", p.description) : String.format("'%s'", p.description);
    }

    protected String toStringOf(Date date) {
        return DateUtil.formatAsDatetimeWithMs(date) + this.classNameDisambiguation(date);
    }

    protected String toStringOf(LocalDateTime localDateTime) {
        return this.defaultToStringWithClassNameDisambiguation(localDateTime);
    }

    protected String toStringOf(OffsetDateTime offsetDateTime) {
        return this.defaultToStringWithClassNameDisambiguation(offsetDateTime);
    }

    protected String toStringOf(ZonedDateTime zonedDateTime) {
        return this.defaultToStringWithClassNameDisambiguation(zonedDateTime);
    }

    protected String toStringOf(LocalDate localDate) {
        return this.defaultToStringWithClassNameDisambiguation(localDate);
    }

    protected String classNameDisambiguation(Object o) {
        return String.format(" (%s)", o.getClass().getName());
    }

    protected String toStringOf(Float f) {
        return String.format("%sf", f);
    }

    protected String toStringOf(Long l) {
        return String.format("%sL", l);
    }

    protected String toStringOf(File file) {
        return file.getAbsolutePath();
    }

    protected String toStringOf(SimpleDateFormat dateFormat) {
        return dateFormat.toPattern();
    }

    protected String toStringOf(Future<?> future) {
        String className = future.getClass().getSimpleName();
        if (!future.isDone()) {
            return Strings.concat(className, "[Incomplete]");
        }
        try {
            Object joinResult = future.get();
            Object joinResultRepresentation = joinResult instanceof Future ? joinResult : this.toStringOf(joinResult);
            return Strings.concat(className, "[Completed: ", joinResultRepresentation, DEFAULT_END);
        }
        catch (CancellationException e) {
            return Strings.concat(className, "[Cancelled]");
        }
        catch (InterruptedException e) {
            return Strings.concat(className, "[Interrupted]");
        }
        catch (ExecutionException e) {
            String stackTrace = e.getCause() != null ? Throwables.getStackTrace(e.getCause()) : Throwables.getStackTrace(e);
            return Strings.concat(className, "[Failed with the following stack trace:", String.format("%n%s", stackTrace), DEFAULT_END);
        }
    }

    protected String toStringOf(Tuple tuple) {
        return this.singleLineFormat(tuple.toList(), TUPLE_START, TUPLE_END);
    }

    protected String toStringOf(MapEntry<?, ?> mapEntry) {
        return String.format("MapEntry[key=%s, value=%s]", this.toStringOf(mapEntry.key), this.toStringOf(mapEntry.value));
    }

    protected String toStringOf(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Map<?, ?> sortedMap = StandardRepresentation.toSortedMapIfPossible(map);
        Iterator<Map.Entry<?, ?>> entriesIterator = sortedMap.entrySet().iterator();
        if (!entriesIterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        int printedElements = 0;
        while (true) {
            Map.Entry<?, ?> entry = entriesIterator.next();
            if (printedElements == maxElementsForPrinting) {
                builder.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
                return builder.append("}").toString();
            }
            builder.append(this.format(map, entry.getKey())).append('=').append(this.format(map, entry.getValue()));
            ++printedElements;
            if (!entriesIterator.hasNext()) {
                return builder.append("}").toString();
            }
            builder.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toStringOf(Throwable throwable) {
        String string;
        StackTraceElement[] elements = throwable.getStackTrace();
        if (maxStackTraceElementsDisplayed == 0 || elements == null) {
            return throwable.toString();
        }
        if (maxStackTraceElementsDisplayed >= elements.length) {
            return Throwables.getStackTrace(throwable);
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            pw.println(throwable);
            for (int i = 0; i < maxStackTraceElementsDisplayed; ++i) {
                pw.println("\tat " + elements[i]);
            }
            pw.print("\t...(" + (elements.length - maxStackTraceElementsDisplayed) + " remaining lines not displayed - this can be changed with Assertions.setMaxStackTraceElementsDisplayed)");
            string = sw.toString();
        }
        catch (Throwable throwable2) {
            Closeables.closeQuietly(sw, pw);
            throw throwable2;
        }
        Closeables.closeQuietly(sw, pw);
        return string;
    }

    protected String toStringOf(AtomicReference<?> atomicReference) {
        return String.format("%s[%s]", atomicReference.getClass().getSimpleName(), this.toStringOf(atomicReference.get()));
    }

    protected String toStringOf(AtomicMarkableReference<?> atomicMarkableReference) {
        return String.format("%s[marked=%s, reference=%s]", atomicMarkableReference.getClass().getSimpleName(), atomicMarkableReference.isMarked(), this.toStringOf(atomicMarkableReference.getReference()));
    }

    protected String toStringOf(AtomicStampedReference<?> atomicStampedReference) {
        return String.format("%s[stamp=%s, reference=%s]", atomicStampedReference.getClass().getSimpleName(), atomicStampedReference.getStamp(), this.toStringOf(atomicStampedReference.getReference()));
    }

    protected String multiLineFormat(Iterable<?> iterable) {
        return this.format(iterable, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, INDENTATION_AFTER_NEWLINE, iterable);
    }

    protected String singleLineFormat(Iterable<?> iterable, String start, String end) {
        return this.format(iterable, start, end, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE, iterable);
    }

    protected String smartFormat(Iterable<?> iterable) {
        String singleLineDescription = this.singleLineFormat(iterable, DEFAULT_START, DEFAULT_END);
        return StandardRepresentation.doesDescriptionFitOnSingleLine(singleLineDescription) ? singleLineDescription : this.multiLineFormat(iterable);
    }

    protected String formatArray(Object o) {
        if (!Arrays.isArray(o)) {
            return null;
        }
        return Arrays.isObjectArray(o) ? this.smartFormat((Object[])o) : this.formatPrimitiveArray(o);
    }

    protected String smartFormat(Object[] array) {
        String description = this.singleLineFormat(array, array);
        return StandardRepresentation.doesDescriptionFitOnSingleLine(description) ? description : this.multiLineFormat(array, array);
    }

    protected String formatPrimitiveArray(Object o) {
        if (!Arrays.isArrayTypePrimitive(o)) {
            throw Arrays.notAnArrayOfPrimitives(o);
        }
        Object[] array = StandardRepresentation.toObjectArray(o);
        return this.format(array, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE, (Object)array);
    }

    protected String multiLineFormat(Object[] array, Object root) {
        return this.format(array, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, INDENTATION_AFTER_NEWLINE, root);
    }

    protected String singleLineFormat(Object[] array, Object root) {
        return this.format(array, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR, INDENTATION_FOR_SINGLE_LINE, root);
    }

    protected String format(Object[] array, String start, String end, String elementSeparator, String indentation, Object root) {
        if (array == null) {
            return null;
        }
        List<String> representedElements = this.representElements(Stream.of(array), start, end, elementSeparator, indentation, root);
        return StandardRepresentation.representGroup(representedElements, start, end, elementSeparator, indentation);
    }

    protected String format(Iterable<?> iterable, String start, String end, String elementSeparator, String indentation, Object root) {
        if (iterable == null) {
            return null;
        }
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return start + end;
        }
        List<String> representedElements = this.representElements(Streams.stream(iterable), start, end, elementSeparator, indentation, root);
        return StandardRepresentation.representGroup(representedElements, start, end, elementSeparator, indentation);
    }

    protected String safeStringOf(Object element, String start, String end, String elementSeparator, String indentation, Object root) {
        if (element == root) {
            return Arrays.isArray(root) ? "(this array)" : "(this instance)";
        }
        return element == null ? NULL : this.toStringOf(element);
    }

    private List<String> representElements(Stream<?> elements, String start, String end, String elementSeparator, String indentation, Object root) {
        return elements.map(element -> this.safeStringOf(element, start, end, elementSeparator, indentation, root)).collect(Collectors.toList());
    }

    private static String representGroup(List<String> representedElements, String start, String end, String elementSeparator, String indentation) {
        int size = representedElements.size();
        StringBuilder desc = new StringBuilder(start);
        if (size <= maxElementsForPrinting) {
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    desc.append(indentation);
                }
                desc.append(representedElements.get(i));
                if (i == size - 1) continue;
                desc.append(elementSeparator);
            }
            return desc.append(end).toString();
        }
        int maxFirstElementsToPrint = (maxElementsForPrinting + 1) / 2;
        for (int i = 0; i < maxFirstElementsToPrint; ++i) {
            desc.append(representedElements.get(i)).append(elementSeparator).append(indentation);
        }
        desc.append(DEFAULT_MAX_ELEMENTS_EXCEEDED);
        if (elementSeparator.contains(System.lineSeparator())) {
            desc.append(System.lineSeparator());
        }
        int maxLastElementsToPrint = maxElementsForPrinting / 2;
        for (int i = size - maxLastElementsToPrint; i < size; ++i) {
            if (i != size - maxLastElementsToPrint) {
                desc.append(elementSeparator);
            }
            desc.append(indentation).append(representedElements.get(i));
        }
        return desc.append(end).toString();
    }

    private String toStringOf(ChangeDelta<?> changeDelta) {
        return String.format("Changed content at line %s:%nexpecting:%n  %s%nbut was:%n  %s%n", changeDelta.lineNumber(), this.formatLines(changeDelta.getOriginal().getLines()), this.formatLines(changeDelta.getRevised().getLines()));
    }

    private String toStringOf(DeleteDelta<?> deleteDelta) {
        return String.format("Missing content at line %s:%n  %s%n", deleteDelta.lineNumber(), this.formatLines(deleteDelta.getOriginal().getLines()));
    }

    private String toStringOf(InsertDelta<?> insertDelta) {
        return String.format("Extra content at line %s:%n  %s%n", insertDelta.lineNumber(), this.formatLines(insertDelta.getRevised().getLines()));
    }

    private String toStringOf(Duration duration) {
        return duration.toString().substring(2);
    }

    private String formatLines(List<?> lines) {
        return this.format(lines, DEFAULT_START, DEFAULT_END, ELEMENT_SEPARATOR_WITH_NEWLINE, "   ", lines);
    }

    private static boolean doesDescriptionFitOnSingleLine(String singleLineDescription) {
        return singleLineDescription == null || singleLineDescription.length() <= maxLengthForSingleLineDescription;
    }

    private static String identityHexCodeOf(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    private static Object classNameOf(Object obj) {
        return obj.getClass().isAnonymousClass() ? obj.getClass().getName() : obj.getClass().getSimpleName();
    }

    private String defaultToStringWithClassNameDisambiguation(Object o) {
        return o.toString() + this.classNameDisambiguation(o);
    }

    private static Map<?, ?> toSortedMapIfPossible(Map<?, ?> map) {
        try {
            return new TreeMap(map);
        }
        catch (ClassCastException | NullPointerException e) {
            return map;
        }
    }

    private String format(Map<?, ?> map, Object o) {
        return o == map ? "(this Map)" : this.toStringOf(o);
    }

    private static Object[] toObjectArray(Object o) {
        int length = Array.getLength(o);
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Array.get(o, i);
        }
        return array;
    }

    protected static enum GroupType {
        ITERABLE("iterable"),
        ARRAY("array");

        private String description;

        private GroupType(String value) {
            this.description = value;
        }

        public String description() {
            return this.description;
        }
    }
}

