/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.implementation;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.internal.bytebuddy.description.field.FieldDescription;
import org.assertj.core.internal.bytebuddy.description.field.FieldList;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeList;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.FieldLocator;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.LoadedTypeInitializer;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.assign.Assigner;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.constant.MethodConstant;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.assertj.core.internal.bytebuddy.jar.asm.MethodVisitor;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.internal.bytebuddy.utility.RandomString;

public abstract class InvocationHandlerAdapter
implements Implementation {
    private static final TypeDescription.Generic INVOCATION_HANDLER_TYPE = new TypeDescription.Generic.OfNonGenericType.ForLoadedType(InvocationHandler.class);
    private static final boolean NO_CACHING = false;
    protected static final boolean CACHING = true;
    protected final String fieldName;
    protected final Assigner assigner;
    protected final boolean cacheMethods;

    protected InvocationHandlerAdapter(String fieldName, boolean cacheMethods, Assigner assigner) {
        this.fieldName = fieldName;
        this.cacheMethods = cacheMethods;
        this.assigner = assigner;
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler) {
        return InvocationHandlerAdapter.of(invocationHandler, String.format("%s$%s", "invocationHandler", RandomString.hashOf(invocationHandler.hashCode())));
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler, String fieldName) {
        return new ForInstance(fieldName, true, Assigner.DEFAULT, invocationHandler);
    }

    public static InvocationHandlerAdapter toField(String name) {
        return InvocationHandlerAdapter.toField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
    }

    public static InvocationHandlerAdapter toField(String name, FieldLocator.Factory fieldLocatorFactory) {
        return new ForField(name, true, Assigner.DEFAULT, fieldLocatorFactory);
    }

    private List<StackManipulation> argumentValuesOf(MethodDescription instrumentedMethod) {
        TypeList.Generic parameterTypes = instrumentedMethod.getParameters().asTypeList();
        ArrayList<StackManipulation> instruction = new ArrayList<StackManipulation>(parameterTypes.size());
        int currentIndex = 1;
        for (TypeDescription.Generic parameterType : parameterTypes) {
            instruction.add(new StackManipulation.Compound(MethodVariableAccess.of(parameterType).loadFrom(currentIndex), this.assigner.assign(parameterType, TypeDescription.Generic.OBJECT, Assigner.Typing.STATIC)));
            currentIndex += parameterType.getStackSize().getSize();
        }
        return instruction;
    }

    public abstract AssignerConfigurable withoutMethodCache();

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, StackManipulation preparingManipulation, FieldDescription fieldDescription) {
        if (instrumentedMethod.isStatic()) {
            throw new IllegalStateException("It is not possible to apply an invocation handler onto the static method " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(preparingManipulation, FieldAccess.forField(fieldDescription).read(), MethodVariableAccess.loadThis(), this.cacheMethods ? MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()).cached() : MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()), ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(this.argumentValuesOf(instrumentedMethod)), MethodInvocation.invoke((MethodDescription)INVOCATION_HANDLER_TYPE.getDeclaredMethods().getOnly()), this.assigner.assign(TypeDescription.Generic.OBJECT, instrumentedMethod.getReturnType(), Assigner.Typing.DYNAMIC), MethodReturn.of(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationHandlerAdapter)) {
            return false;
        }
        InvocationHandlerAdapter other = (InvocationHandlerAdapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldName = this.fieldName;
        String other$fieldName = other.fieldName;
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        return this.cacheMethods == other.cacheMethods;
    }

    protected boolean canEqual(Object other) {
        return other instanceof InvocationHandlerAdapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.fieldName;
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        result = result * 59 + (this.cacheMethods ? 79 : 97);
        return result;
    }

    protected static class ForField
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        private final FieldLocator.Factory fieldLocatorFactory;

        protected ForField(String fieldName, boolean cacheMethods, Assigner assigner, FieldLocator.Factory fieldLocatorFactory) {
            super(fieldName, cacheMethods, assigner);
            this.fieldLocatorFactory = fieldLocatorFactory;
        }

        @Override
        public AssignerConfigurable withoutMethodCache() {
            return new ForField(this.fieldName, false, this.assigner, this.fieldLocatorFactory);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForField(this.fieldName, this.cacheMethods, assigner, this.fieldLocatorFactory);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()).locate(this.fieldName);
            if (!resolution.isResolved()) {
                throw new IllegalStateException("Could not find a field named '" + this.fieldName + "' for " + implementationTarget.getInstrumentedType());
            }
            if (!resolution.getField().getType().asErasure().isAssignableTo(InvocationHandler.class)) {
                throw new IllegalStateException("Field " + resolution.getField() + " does not declare a type that is assignable to invocation handler");
            }
            return new Appender(implementationTarget.getInstrumentedType(), resolution.getField());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForField)) {
                return false;
            }
            ForField other = (ForField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldLocator.Factory this$fieldLocatorFactory = this.fieldLocatorFactory;
            FieldLocator.Factory other$fieldLocatorFactory = other.fieldLocatorFactory;
            return !(this$fieldLocatorFactory == null ? other$fieldLocatorFactory != null : !this$fieldLocatorFactory.equals(other$fieldLocatorFactory));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForField;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            FieldLocator.Factory $fieldLocatorFactory = this.fieldLocatorFactory;
            result = result * 59 + ($fieldLocatorFactory == null ? 43 : $fieldLocatorFactory.hashCode());
            return result;
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;
            private final FieldDescription fieldDescription;

            protected Appender(TypeDescription instrumentedType, FieldDescription fieldDescription) {
                this.instrumentedType = instrumentedType;
                this.fieldDescription = fieldDescription;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForField.this.apply(methodVisitor, implementationContext, instrumentedMethod, this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), this.fieldDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && this.fieldDescription.equals(((Appender)other).fieldDescription) && ForField.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForField.this;
            }

            public int hashCode() {
                return 31 * (31 * ForField.this.hashCode() + this.instrumentedType.hashCode()) + this.fieldDescription.hashCode();
            }
        }
    }

    protected static class ForInstance
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        private static final String PREFIX = "invocationHandler";
        protected final InvocationHandler invocationHandler;

        protected ForInstance(String fieldName, boolean cacheMethods, Assigner assigner, InvocationHandler invocationHandler) {
            super(fieldName, cacheMethods, assigner);
            this.invocationHandler = invocationHandler;
        }

        @Override
        public AssignerConfigurable withoutMethodCache() {
            return new ForInstance(this.fieldName, false, this.assigner, this.invocationHandler);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForInstance(this.fieldName, this.cacheMethods, assigner, this.invocationHandler);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, INVOCATION_HANDLER_TYPE)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.invocationHandler));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForInstance)) {
                return false;
            }
            ForInstance other = (ForInstance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InvocationHandler this$invocationHandler = this.invocationHandler;
            InvocationHandler other$invocationHandler = other.invocationHandler;
            return !(this$invocationHandler == null ? other$invocationHandler != null : !this$invocationHandler.equals(other$invocationHandler));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForInstance;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            InvocationHandler $invocationHandler = this.invocationHandler;
            result = result * 59 + ($invocationHandler == null ? 43 : $invocationHandler.hashCode());
            return result;
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForInstance.this.apply(methodVisitor, implementationContext, instrumentedMethod, StackManipulation.Trivial.INSTANCE, (FieldDescription)((FieldList)this.instrumentedType.getDeclaredFields().filter(ElementMatchers.named(ForInstance.this.fieldName).and(ElementMatchers.genericFieldType(INVOCATION_HANDLER_TYPE)))).getOnly());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForInstance.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForInstance.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            public int hashCode() {
                return 31 * ForInstance.this.hashCode() + this.instrumentedType.hashCode();
            }
        }
    }

    protected static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1);
    }
}

