/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao;

import java.util.Collection;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Arrays;

public class Operation {
    public final OperationType type;
    public final Object data;

    public Operation(OperationType type, Object data) {
        this.type = type;
        this.data = data;
    }

    public static Builder saveOrUpdate(Collection<?> entities) {
        return new Builder().saveOrUpdate(entities);
    }

    public static Builder saveOrUpdate(Object ... entities) {
        return new Builder().saveOrUpdate(entities);
    }

    public static Builder remove(Collection<?> entities) {
        return new Builder().remove(entities);
    }

    public static Builder remove(Object ... entities) {
        return new Builder().remove(entities);
    }

    public static class Builder {
        private List<Operation> operations = CollectUtils.newArrayList();

        public Builder saveOrUpdate(Collection<?> entities) {
            if (CollectUtils.isEmpty(entities)) {
                return this;
            }
            for (Object entity : entities) {
                if (null == entity) continue;
                this.operations.add(new Operation(OperationType.SAVE_UPDATE, entity));
            }
            return this;
        }

        public Builder saveOrUpdate(Object ... entities) {
            if (Arrays.isEmpty((Object[])entities)) {
                return this;
            }
            for (Object entity : entities) {
                if (null == entity) continue;
                this.operations.add(new Operation(OperationType.SAVE_UPDATE, entity));
            }
            return this;
        }

        public Builder remove(Collection<?> entities) {
            if (CollectUtils.isEmpty(entities)) {
                return this;
            }
            for (Object entity : entities) {
                if (null == entity) continue;
                this.operations.add(new Operation(OperationType.REMOVE, entity));
            }
            return this;
        }

        public Builder remove(Object ... entities) {
            if (Arrays.isEmpty((Object[])entities)) {
                return this;
            }
            for (Object entity : entities) {
                if (null == entity) continue;
                this.operations.add(new Operation(OperationType.REMOVE, entity));
            }
            return this;
        }

        public List<Operation> build() {
            return this.operations;
        }
    }

    public static enum OperationType {
        SAVE_UPDATE,
        REMOVE;

    }
}

