/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.query.builder;

import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.Order;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.dao.query.Lang;
import org.beangle.commons.dao.query.Query;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.Conditions;
import org.beangle.commons.dao.query.builder.QueryBean;
import org.beangle.commons.lang.Strings;

public abstract class AbstractQueryBuilder<T>
implements QueryBuilder<T> {
    public static final String INNER_JOIN = " left join ";
    public static final String OUTER_JOIN = " outer join ";
    public static final String LEFT_OUTER_JOIN = " left outer join ";
    public static final String RIGHT_OUTER_JOIN = " right outer join ";
    protected String statement;
    protected PageLimit limit;
    protected Map<String, Object> params = CollectUtils.newHashMap();
    protected String select;
    protected String from;
    protected String alias;
    protected List<Condition> conditions = CollectUtils.newArrayList();
    protected List<Order> orders = CollectUtils.newArrayList();
    protected List<String> groups = CollectUtils.newArrayList();
    protected String having;
    protected boolean cacheable = false;

    @Override
    public Map<String, Object> getParams() {
        return CollectUtils.newHashMap(this.params);
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public PageLimit getLimit() {
        return this.limit;
    }

    @Override
    public Query<T> build() {
        QueryBean queryBean = new QueryBean();
        queryBean.setStatement(this.genStatement());
        queryBean.setParams(this.getParams());
        if (null != this.limit) {
            queryBean.setLimit(new PageLimit(this.limit.getPageNo(), this.limit.getPageSize()));
        }
        queryBean.setCountStatement(this.genCountStatement());
        queryBean.setCacheable(this.cacheable);
        queryBean.setLang(this.getLang());
        return queryBean;
    }

    protected abstract Lang getLang();

    protected String genStatement() {
        if (Strings.isNotEmpty((CharSequence)this.statement)) {
            return this.statement;
        }
        return this.genQueryStatement(true);
    }

    protected abstract String genCountStatement();

    protected String genQueryStatement(boolean hasOrder) {
        if (null == this.from) {
            return this.statement;
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append(this.select == null ? "" : this.select + " ").append(this.from);
        if (!this.conditions.isEmpty()) {
            buf.append(" where ").append(Conditions.toQueryString(this.conditions));
        }
        if (!this.groups.isEmpty()) {
            buf.append(" group by ");
            for (String groupBy : this.groups) {
                buf.append(groupBy).append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
        }
        if (hasOrder && !CollectUtils.isEmpty(this.orders)) {
            buf.append(' ').append(Order.toSortString(this.orders));
        }
        if (null != this.having) {
            buf.append(" having ").append(this.having);
        }
        return buf.toString();
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }
}

