/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.query.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.entity.Component;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.util.ValidEntityKeyPredicate;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conditions {
    private static final Logger logger = LoggerFactory.getLogger(Conditions.class);

    private Conditions() {
    }

    public static Condition and(Condition ... conditions) {
        return Conditions.concat(Arrays.asList(conditions), "and");
    }

    public static Condition and(List<Condition> conditions) {
        return Conditions.concat(conditions, "and");
    }

    public static Condition or(Condition ... conditions) {
        return Conditions.concat(Arrays.asList(conditions), "or");
    }

    public static Condition or(List<Condition> conditions) {
        return Conditions.concat(conditions, "or");
    }

    static Condition concat(List<Condition> conditions, String andor) {
        Assert.isTrue((!conditions.isEmpty() ? 1 : 0) != 0, (String)"conditions shouldn't be empty!", (Object[])new Object[0]);
        if (conditions.size() == 1) {
            return conditions.get(0);
        }
        StringBuffer sb = new StringBuffer();
        List params = CollectUtils.newArrayList();
        sb.append("(");
        for (Condition con : conditions) {
            sb.append(" " + andor + " (");
            sb.append(con.getContent());
            sb.append(')');
            params.addAll(con.getParams());
        }
        sb.append(")");
        sb.replace(0, (" " + andor + " ").length() + 1, "(");
        return new Condition(sb.toString()).params(params);
    }

    public static String toQueryString(List<Condition> conditions) {
        if (null == conditions || conditions.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder("");
        Iterator<Condition> iter = conditions.iterator();
        while (iter.hasNext()) {
            Condition con = iter.next();
            buf.append('(').append(con.getContent()).append(')');
            if (!iter.hasNext()) continue;
            buf.append(" and ");
        }
        return buf.toString();
    }

    public static List<Condition> extractConditions(String alias, Entity<?> entity) {
        if (null == entity) {
            return Collections.emptyList();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        StringBuilder aliasBuilder = new StringBuilder(alias == null ? "" : alias);
        if (aliasBuilder.length() > 0 && !alias.endsWith(".")) {
            aliasBuilder.append(".");
        }
        String attr2 = "";
        try {
            Set props = PropertyUtils.getWritableProperties(entity.getClass());
            for (String attr2 : props) {
                Object value = PropertyUtils.getProperty(entity, (String)attr2);
                if (null == value || value instanceof Collection) continue;
                Conditions.addAttrCondition(conditions, alias + attr2, value);
            }
        }
        catch (Exception e) {
            logger.debug("error occur in extractConditions for  bean {} with attr named {}", entity, (Object)attr2);
        }
        return conditions;
    }

    public static Map<String, Object> getParamMap(Collection<Condition> conditions) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Condition con : conditions) {
            params.putAll(Conditions.getParamMap(con));
        }
        return params;
    }

    public static Map<String, Object> getParamMap(Condition condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!Strings.contains((CharSequence)condition.getContent(), (CharSequence)"?")) {
            List<String> paramNames = condition.getParamNames();
            for (int i = 0; i < paramNames.size() && i < condition.getParams().size(); ++i) {
                params.put(paramNames.get(i), condition.getParams().get(i));
            }
        }
        return params;
    }

    private static void addAttrCondition(List<Condition> conditions, String name, Object value) {
        if (value instanceof String) {
            if (Strings.isBlank((CharSequence)((String)value))) {
                return;
            }
            StringBuilder content = new StringBuilder(name);
            content.append(" like :").append(name.replace('.', '_'));
            conditions.add(new Condition(content.toString(), "%" + value + "%"));
        } else {
            if (value instanceof Component) {
                conditions.addAll(Conditions.extractComponent(name, (Component)value));
                return;
            }
            if (value instanceof Entity) {
                try {
                    String key = "id";
                    Object property = PropertyUtils.getProperty((Object)value, (String)"id");
                    if (ValidEntityKeyPredicate.Instance.apply(property).booleanValue()) {
                        StringBuilder content = new StringBuilder(name);
                        content.append('.').append("id").append(" = :").append(name.replace('.', '_')).append('_').append("id");
                        conditions.add(new Condition(content.toString(), property));
                    }
                }
                catch (Exception e) {
                    logger.warn("getProperty " + value + "error", (Throwable)e);
                }
            } else {
                conditions.add(new Condition(name + " = :" + name.replace('.', '_'), value));
            }
        }
    }

    private static List<Condition> extractComponent(String prefix, Component component) {
        if (null == component) {
            return Collections.emptyList();
        }
        List conditions = CollectUtils.newArrayList();
        String attr2 = "";
        try {
            Set props = PropertyUtils.getWritableProperties(component.getClass());
            for (String attr2 : props) {
                Object value = PropertyUtils.getProperty((Object)component, (String)attr2);
                if (value == null) continue;
                if (value instanceof Collection) {
                    if (!((Collection)value).isEmpty()) continue;
                    continue;
                }
                Conditions.addAttrCondition(conditions, prefix + "." + attr2, value);
            }
        }
        catch (Exception e) {
            logger.warn("error occur in extractComponent of component:" + component + "with attr named :" + attr2);
        }
        return conditions;
    }
}

