/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.query.builder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.Order;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.dao.query.Lang;
import org.beangle.commons.dao.query.Query;
import org.beangle.commons.dao.query.builder.AbstractQuery;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.Conditions;
import org.beangle.commons.dao.query.builder.QueryBean;
import org.beangle.commons.lang.Strings;

public class SqlQuery
extends AbstractQuery<Object> {
    public static final String INNER_JOIN = " left join ";
    public static final String OUTER_JOIN = " outer join ";
    public static final String LEFT_OUTER_JOIN = " left outer join ";
    public static final String RIGHT_OUTER_JOIN = " right outer join ";
    protected String select;
    protected String from;
    protected List<Condition> conditions = CollectUtils.newArrayList();
    protected List<Order> orders = CollectUtils.newArrayList();
    protected List<String> groups = CollectUtils.newArrayList();

    public SqlQuery() {
    }

    public SqlQuery(String queryStr) {
        this.queryStr = queryStr;
    }

    public SqlQuery add(Condition condition) {
        this.conditions.add(condition);
        return this;
    }

    public SqlQuery add(Collection<Condition> cons) {
        this.conditions.addAll(cons);
        return this;
    }

    public SqlQuery addOrder(Order order) {
        if (null != order) {
            this.orders.add(order);
        }
        return this;
    }

    public SqlQuery addOrder(List<Order> orders) {
        if (null != orders) {
            this.orders.addAll(orders);
        }
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = null == select ? null : (Strings.contains((CharSequence)select.toLowerCase(), (CharSequence)"select") ? select : "select " + select);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = null == from ? null : (Strings.contains((CharSequence)from.toLowerCase(), (CharSequence)"from") ? from : " from " + from);
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public SqlQuery groupBy(String what) {
        if (Strings.isNotEmpty((CharSequence)what)) {
            this.groups.add(what);
        }
        return this;
    }

    @Override
    public String toQueryString() {
        if (Strings.isNotEmpty((CharSequence)this.queryStr)) {
            return this.queryStr;
        }
        return this.genQueryString(true);
    }

    @Override
    public String toCountString() {
        if (Strings.isNotEmpty((CharSequence)this.countStr)) {
            return this.countStr;
        }
        return "select count(*) from (" + this.genQueryString(false) + ")";
    }

    protected String genQueryString(boolean hasOrder) {
        if (null == this.from) {
            return this.queryStr;
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append(this.select == null ? "" : this.select).append(' ').append(this.from);
        if (!this.conditions.isEmpty()) {
            buf.append(" where ").append(Conditions.toQueryString(this.conditions));
        }
        if (!this.groups.isEmpty()) {
            buf.append(" group by ");
            for (String groupBy : this.groups) {
                buf.append(groupBy).append(',');
            }
            buf.deleteCharAt(buf.length() - 1);
        }
        if (hasOrder && !CollectUtils.isEmpty(this.orders)) {
            buf.append(' ').append(Order.toSortString(this.orders));
        }
        return buf.toString();
    }

    @Override
    public Map<String, Object> getParams() {
        return null == this.params ? Conditions.getParamMap(this.conditions) : CollectUtils.newHashMap((Map)this.params);
    }

    @Override
    public Query<Object> build() {
        QueryBean<Object> queryBean = new QueryBean<Object>();
        queryBean.setStatement(this.toQueryString());
        queryBean.setParams(CollectUtils.newHashMap(this.getParams()));
        if (null != this.limit) {
            queryBean.setLimit(new PageLimit(this.limit.getPageNo(), this.limit.getPageSize()));
        }
        queryBean.setCountStatement(this.toCountString());
        queryBean.setCacheable(this.cacheable);
        queryBean.setLang(this.getLang());
        return queryBean;
    }

    protected Lang getLang() {
        return Lang.SQL;
    }

    public SqlQuery limit(PageLimit limit) {
        this.limit = limit;
        return this;
    }

    public SqlQuery params(Map<String, Object> newParams) {
        this.params = CollectUtils.newHashMap(newParams);
        return this;
    }
}

