/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.metadata;

import java.lang.reflect.Array;
import org.beangle.commons.entity.metadata.AbstractType;
import org.beangle.commons.entity.metadata.Type;

public class CollectionType
extends AbstractType {
    private Class<?> collectionClass;
    private Type elementType;
    private Class<?> indexClass;
    private boolean array = false;

    @Override
    public boolean isCollectionType() {
        return true;
    }

    @Override
    public String getName() {
        StringBuilder buffer = new StringBuilder();
        if (null != this.collectionClass) {
            buffer.append(this.collectionClass.getName());
        }
        buffer.append(':');
        if (null != this.indexClass) {
            buffer.append(this.indexClass.getName());
        }
        buffer.append(':');
        buffer.append(this.elementType.getName());
        return buffer.toString();
    }

    @Override
    public Type getPropertyType(String property) {
        return this.elementType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public void setElementType(Type elementType) {
        this.elementType = elementType;
    }

    public Class<?> getIndexClass() {
        return this.indexClass;
    }

    public boolean hasIndex() {
        return null != this.indexClass && this.indexClass.equals(Integer.TYPE);
    }

    @Override
    public Class<?> getReturnedClass() {
        return this.collectionClass;
    }

    public Class<?> getCollectionClass() {
        return this.collectionClass;
    }

    public void setCollectionClass(Class<?> collectionClass) {
        this.collectionClass = collectionClass;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean isArray) {
        this.array = isArray;
    }

    @Override
    public Object newInstance() {
        if (this.array) {
            return Array.newInstance(this.elementType.getReturnedClass(), 0);
        }
        return super.newInstance();
    }
}

