/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.metadata.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.Type;
import org.beangle.commons.entity.metadata.impl.AbstractEntityContext;
import org.beangle.commons.lang.ClassLoaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEntityContext
extends AbstractEntityContext
implements Initializing {
    private static final Logger logger = LoggerFactory.getLogger(SimpleEntityContext.class);

    public void init() throws Exception {
        Properties props = new Properties();
        try {
            InputStream is = ClassLoaders.getResourceAsStream((String)"model.properties", this.getClass());
            if (null != is) {
                props.load(is);
            }
        }
        catch (IOException e) {
            logger.error("read error model.properties");
        }
        if (!props.isEmpty()) {
            logger.info("Using model.properties initialize Entity Context.");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                EntityType entityType = null;
                try {
                    entityType = new EntityType(key, Class.forName(value), "id");
                }
                catch (ClassNotFoundException e) {
                    logger.error(value + " was not correct class name", (Throwable)e);
                }
                entityType.setPropertyTypes(new HashMap<String, Type>());
                this.entityTypes.put(key, entityType);
            }
        }
    }
}

