/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.orm;

import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.orm.EntityPersistConfig;

public abstract class AbstractPersistModule {
    private EntityPersistConfig config = null;

    protected abstract void doConfig();

    protected final EntityHolder add(Class<? extends Entity<?>> ... classes) {
        for (Class<? extends Entity<?>> cls : classes) {
            this.config.addEntity(new EntityPersistConfig.EntityDefinition(cls));
        }
        return new EntityHolder(classes, this.config);
    }

    protected final CacheHolder cache(String region) {
        return new CacheHolder(this.config).cache(region).usage(this.config.getCache().getUsage());
    }

    protected final CacheHolder cache() {
        return new CacheHolder(this.config).cache(this.config.getCache().region).usage(this.config.getCache().getUsage());
    }

    protected final List<EntityPersistConfig.CollectionDefinition> collection(Class<?> clazz, String ... properties) {
        List definitions = CollectUtils.newArrayList((int)properties.length);
        for (String property : properties) {
            definitions.add(new EntityPersistConfig.CollectionDefinition(clazz, property));
        }
        return definitions;
    }

    protected final void defaultCache(String region, String usage) {
        this.config.cache.setRegion(region);
        this.config.cache.setUsage(usage);
    }

    public final EntityPersistConfig getConfig() {
        this.config = new EntityPersistConfig();
        this.doConfig();
        return this.config;
    }

    public static final class EntityHolder {
        final Class<?>[] classes;
        final EntityPersistConfig config;

        public EntityHolder(Class<?>[] classes, EntityPersistConfig config) {
            this.classes = classes;
            this.config = config;
        }

        public EntityHolder cacheable() {
            for (Class<?> clazz : this.classes) {
                this.config.getEntity(clazz).cache(this.config.getCache().getRegion(), this.config.getCache().getUsage());
            }
            return this;
        }

        public EntityHolder cache(String region) {
            for (Class<?> clazz : this.classes) {
                this.config.getEntity(clazz).setCacheRegion(region);
            }
            return this;
        }

        public EntityHolder usage(String usage) {
            for (Class<?> clazz : this.classes) {
                this.config.getEntity(clazz).setCacheUsage(usage);
            }
            return this;
        }
    }

    public static final class CacheHolder {
        final EntityPersistConfig config;
        String cacheUsage;
        String cacheRegion;

        public CacheHolder(EntityPersistConfig config) {
            this.config = config;
        }

        public CacheHolder add(List<EntityPersistConfig.CollectionDefinition> ... definitionLists) {
            for (List<EntityPersistConfig.CollectionDefinition> definitions : definitionLists) {
                for (EntityPersistConfig.CollectionDefinition definition : definitions) {
                    this.config.addCollection(definition.cache(this.cacheRegion, this.cacheUsage));
                }
            }
            return this;
        }

        public CacheHolder add(Class<? extends Entity<?>> ... classes) {
            for (Class<? extends Entity<?>> clazz : classes) {
                this.config.getEntity(clazz).cache(this.cacheRegion, this.cacheUsage);
            }
            return this;
        }

        public CacheHolder usage(String cacheUsage) {
            this.cacheUsage = cacheUsage;
            return this;
        }

        public CacheHolder cache(String cacheRegion) {
            this.cacheRegion = cacheRegion;
            return this;
        }
    }
}

