/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.pojo;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.HierarchyEntity;
import org.beangle.commons.entity.pojo.NumberIdObject;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;

@MappedSuperclass
public abstract class NumberIdHierarchyObject<T, ID extends Number>
extends NumberIdObject<ID>
implements HierarchyEntity<T, ID>,
Comparable<T> {
    private static final long serialVersionUID = -968320812584144969L;
    @Size(max=30)
    @NotNull
    protected String indexno;
    @ManyToOne(fetch=FetchType.LAZY)
    public T parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    @OrderBy(value="indexno")
    protected List<T> children = CollectUtils.newArrayList();

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public void setParent(T parent) {
        this.parent = parent;
    }

    @Override
    public List<T> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<T> children) {
        this.children = children;
    }

    public int getDepth() {
        return null == this.getParent() ? 1 : this.getParentNode().getDepth() + 1;
    }

    public int getIndex() {
        int idx;
        String index = Strings.substringAfterLast((String)this.indexno, (String)".");
        if (Strings.isEmpty((CharSequence)index)) {
            index = this.indexno;
        }
        if ((idx = Numbers.toInt((String)index)) <= 0) {
            idx = 1;
        }
        return idx;
    }

    public void genIndexno(String indexno) {
        this.indexno = null == this.getParent() ? indexno : Strings.concat((String[])new String[]{this.getParentNode().getIndexno(), ".", indexno});
    }

    public void genIndexno() {
        if (null != this.getParent()) {
            this.indexno = Strings.concat((String[])new String[]{this.getParentNode().getIndexno(), ".", String.valueOf(this.getIndex())});
        }
    }

    protected NumberIdHierarchyObject<?, ?> getParentNode() {
        return (NumberIdHierarchyObject)this.getParent();
    }

    @Override
    public String getIndexno() {
        return this.indexno;
    }

    public void setIndexno(String indexno) {
        this.indexno = indexno;
    }

    @Override
    public int compareTo(T other) {
        return this.getIndexno().compareTo(((NumberIdHierarchyObject)other).getIndexno());
    }
}

