/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.HierarchyEntity;
import org.beangle.commons.lang.Objects;

public final class HierarchyEntityUtils {
    public static <T extends HierarchyEntity<T, ?>> Set<T> getFamily(T root) {
        Set nodes = CollectUtils.newHashSet();
        nodes.add(root);
        HierarchyEntityUtils.loadChildren(root, nodes);
        return nodes;
    }

    private static <T extends HierarchyEntity<T, ?>> void loadChildren(T node, Set<T> children) {
        if (null == node.getChildren()) {
            return;
        }
        for (HierarchyEntity one : node.getChildren()) {
            children.add(one);
            HierarchyEntityUtils.loadChildren(one, children);
        }
    }

    public static <T extends HierarchyEntity<T, ?>> Map<T, String> sort(List<T> datas) {
        return HierarchyEntityUtils.sort(datas, null);
    }

    public static <T extends HierarchyEntity<T, ?>> Map<T, String> sort(List<T> datas, String property) {
        final Map<T, String> sortedMap = HierarchyEntityUtils.tag(datas, property);
        Collections.sort(datas, new Comparator<HierarchyEntity<T, ?>>(){

            @Override
            public int compare(HierarchyEntity<T, ?> arg0, HierarchyEntity<T, ?> arg1) {
                String tag0 = (String)sortedMap.get(arg0);
                String tag1 = (String)sortedMap.get(arg1);
                return tag0.compareTo(tag1);
            }
        });
        return sortedMap;
    }

    public static <T extends HierarchyEntity<T, ?>> Map<T, String> tag(List<T> datas, String property) {
        Map sortedMap = CollectUtils.newHashMap();
        for (HierarchyEntity de : datas) {
            String myId = null;
            if (null == property) {
                myId = String.valueOf(de.getId());
            } else {
                try {
                    myId = String.valueOf(PropertyUtils.getProperty((Object)de, (String)property));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            myId = myId + "_";
            if (null != de.getParent() && sortedMap.containsKey(de.getParent()) && !(myId = String.valueOf((String)sortedMap.get(de.getParent()) + myId)).endsWith("_")) {
                myId = myId + "_";
            }
            HierarchyEntityUtils.updatedTagFor(myId, de, sortedMap);
            sortedMap.put(de, myId);
        }
        for (HierarchyEntity de : datas) {
            String tag = (String)sortedMap.get(de);
            if (!tag.endsWith("_")) continue;
            sortedMap.put(de, tag.substring(0, tag.length() - 1));
        }
        return sortedMap;
    }

    private static <T extends HierarchyEntity<T, ?>> void updatedTagFor(String prefix, T root, Map<T, String> sortedMap) {
        for (HierarchyEntity child : root.getChildren()) {
            if (!sortedMap.containsKey(child)) continue;
            sortedMap.put(child, prefix + sortedMap.get(child));
            HierarchyEntityUtils.updatedTagFor(prefix, child, sortedMap);
        }
    }

    public static <T extends HierarchyEntity<T, ?>> List<T> getRoots(List<T> nodes) {
        List roots = CollectUtils.newArrayList();
        for (HierarchyEntity m : nodes) {
            if (null != m.getParent() && nodes.contains(m.getParent())) continue;
            roots.add(m);
        }
        return roots;
    }

    public static <T extends HierarchyEntity<T, ?>> List<T> getPath(T node) {
        List path = CollectUtils.newArrayList();
        for (Object curNode = node; null != curNode && !path.contains(curNode); curNode = (HierarchyEntity)curNode.getParent()) {
            path.add(0, curNode);
        }
        return path;
    }

    public static <T extends HierarchyEntity<T, ?>> void addParent(Collection<T> nodes) {
        HierarchyEntityUtils.addParent(nodes, null);
    }

    public static <T extends HierarchyEntity<T, ?>> void addParent(Collection<T> nodes, T toRoot) {
        Set parents = CollectUtils.newHashSet();
        for (HierarchyEntity node : nodes) {
            while (null != node.getParent() && !parents.contains(node.getParent()) && !Objects.equals(node.getParent(), toRoot)) {
                parents.add(node.getParent());
                node = (HierarchyEntity)node.getParent();
            }
        }
        nodes.addAll(parents);
    }
}

