/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.excel;

import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.transfer.exporter.Context;
import org.beangle.commons.transfer.io.AbstractItemWriter;
import org.beangle.commons.transfer.io.TransferFormat;

public class ExcelItemWriter
extends AbstractItemWriter {
    protected int countPerSheet = 50000;
    protected HSSFWorkbook workbook = new HSSFWorkbook();
    protected int index = 0;
    protected HSSFSheet sheet;
    protected HSSFCellStyle dateStyle = null;
    protected HSSFCellStyle timeStyle = null;
    private Object title;

    public ExcelItemWriter() {
    }

    public ExcelItemWriter(OutputStream outputStream) {
        this();
        this.outputStream = outputStream;
    }

    public int getCountPerSheet() {
        return this.countPerSheet;
    }

    public void setCountPerSheet(int dataNumPerSheet) {
        this.countPerSheet = dataNumPerSheet;
    }

    @Override
    public void write(Object obj) {
        if (this.index + 1 >= this.countPerSheet) {
            this.writeTitle(null, this.title);
        }
        this.writeItem(obj);
        ++this.index;
    }

    @Override
    public void writeTitle(String titleName, Object data) {
        this.sheet = null != titleName ? this.workbook.createSheet(titleName) : this.workbook.createSheet();
        this.title = data;
        this.index = 0;
        this.writeItem(data);
        HSSFRow titleRow = this.sheet.getRow(this.index);
        HSSFCellStyle titleStyle = this.getTitleStyle();
        for (int i = 0; i < titleRow.getLastCellNum(); ++i) {
            titleRow.getCell(i).setCellStyle(titleStyle);
        }
        ++this.index;
    }

    @Override
    public TransferFormat getFormat() {
        return TransferFormat.Xls;
    }

    protected void writeItem(Object datas) {
        HSSFRow row = this.sheet.createRow(this.index);
        if (datas != null) {
            if (datas.getClass().isArray()) {
                Object[] values = (Object[])datas;
                for (int i = 0; i < values.length; ++i) {
                    HSSFCell cell = row.createCell(i);
                    if (values[i] instanceof Number) {
                        cell.setCellType(0);
                        cell.setCellValue(((Number)values[i]).doubleValue());
                        continue;
                    }
                    if (values[i] instanceof java.sql.Date) {
                        cell.setCellValue((Date)values[i]);
                        cell.setCellStyle(this.getDateStyle());
                        continue;
                    }
                    if (values[i] instanceof Date) {
                        cell.setCellValue((Date)values[i]);
                        cell.setCellStyle(this.getTimeStyle());
                        continue;
                    }
                    if (values[i] instanceof Calendar) {
                        cell.setCellValue((Calendar)values[i]);
                        cell.setCellStyle(this.getTimeStyle());
                        continue;
                    }
                    cell.setCellValue((RichTextString)new HSSFRichTextString(values[i] == null ? "" : values[i].toString()));
                }
            } else {
                HSSFCell cell = row.createCell(0);
                if (datas instanceof Number) {
                    cell.setCellType(0);
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(datas.toString()));
            }
        }
    }

    @Override
    public void close() {
        try {
            this.workbook.write(this.outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void setContext(Context context) {
        int countParam;
        Object count;
        super.setContext(context);
        if (null != context && null != (count = context.getDatas().get("countPerSheet")) && Numbers.isDigits((String)count.toString()) && (countParam = Numbers.toInt((String)count.toString())) > 0) {
            this.countPerSheet = countParam;
        }
    }

    private HSSFCellStyle getDateStyle() {
        if (null == this.dateStyle) {
            this.dateStyle = this.workbook.createCellStyle();
            this.dateStyle.setDataFormat(this.workbook.createDataFormat().getFormat(this.getDateFormat()));
        }
        return this.dateStyle;
    }

    private HSSFCellStyle getTimeStyle() {
        if (null == this.timeStyle) {
            this.timeStyle = this.workbook.createCellStyle();
            this.timeStyle.setDataFormat(this.workbook.createDataFormat().getFormat(this.getDateTimeFormat()));
        }
        return this.timeStyle;
    }

    protected String getDateFormat() {
        return "YYYY-MM-DD";
    }

    protected String getDateTimeFormat() {
        return "YYYY-MM-DD HH:MM:SS";
    }

    protected HSSFCellStyle getTitleStyle() {
        HSSFCellStyle style = this.workbook.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setFillPattern((short)1);
        style.setFillForegroundColor((short)22);
        return style;
    }
}

