/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.excel;

import java.io.OutputStream;
import java.net.URL;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.ss.usermodel.Workbook;
import org.beangle.commons.transfer.exporter.Context;
import org.beangle.commons.transfer.exporter.TemplateWriter;
import org.beangle.commons.transfer.io.TransferFormat;

public class ExcelTemplateWriter
implements TemplateWriter {
    protected URL template;
    protected XLSTransformer transformer = new XLSTransformer();
    protected Context context;
    protected OutputStream outputStream;
    protected Workbook workbook;

    public ExcelTemplateWriter() {
    }

    public ExcelTemplateWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public TransferFormat getFormat() {
        return TransferFormat.Xls;
    }

    @Override
    public URL getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(URL template) {
        this.template = template;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void write() {
        try {
            this.workbook = this.transformer.transformXLS(this.template.openStream(), this.context.getDatas());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.workbook.write(this.outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

