/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.excel;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.beangle.commons.transfer.exporter.DefaultPropertyExtractor;
import org.beangle.commons.transfer.exporter.PropertyExtractor;

public class ExcelTools {
    DecimalFormat numberformat = new DecimalFormat("#0.00");

    public HSSFWorkbook toExcel(Collection<Object[]> datas, String propertyShowKeys) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        return this.toExcel(wb, "export data", datas, propertyShowKeys);
    }

    public HSSFWorkbook toExcel(HSSFWorkbook wb, String sheetName, Collection<Object[]> datas, String propertyShowKeys) throws Exception {
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = null;
        HSSFCell cell = null;
        String[] pShowKeys = this.Tokenizer2StringArray(propertyShowKeys, ",");
        row = sheet.createRow(0);
        for (int i = 0; i < pShowKeys.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue((RichTextString)new HSSFRichTextString(pShowKeys[i]));
        }
        int rowId = 1;
        Iterator<Object[]> iter = datas.iterator();
        while (iter.hasNext()) {
            row = sheet.createRow(rowId);
            Object[] objs = iter.next();
            for (int j = 0; j < objs.length; ++j) {
                cell = row.createCell(j);
                cell.setCellValue((RichTextString)new HSSFRichTextString(objs[j] == null ? "" : objs[j].toString()));
            }
            ++rowId;
        }
        return wb;
    }

    public <T> HSSFWorkbook object2Excel(Collection<T> list, String propertyKeys, String propertyShowKeys, PropertyExtractor exporter) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        this.object2Excel(wb, "export result", list, propertyKeys, propertyShowKeys, exporter);
        return wb;
    }

    public <T> HSSFWorkbook object2Excel(HSSFWorkbook wb, String sheetName, Collection<T> list, String propertyKeys, String propertyShowKeys, PropertyExtractor exporter) throws Exception {
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = null;
        HSSFCell cell = null;
        Object cellVal = null;
        String[] pKeys = this.Tokenizer2StringArray(propertyKeys, ",");
        String[] pShowKeys = this.Tokenizer2StringArray(propertyShowKeys, ",");
        row = sheet.createRow(0);
        for (int i = 0; i < pShowKeys.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue((RichTextString)new HSSFRichTextString(pShowKeys[i]));
        }
        int rowId = 1;
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            row = sheet.createRow(rowId);
            T obj = iter.next();
            for (int i = 0; i < pKeys.length; ++i) {
                cell = row.createCell(i);
                cellVal = exporter.getPropertyValue(obj, pKeys[i]);
                String cellValue = "";
                if (null != cellVal) {
                    cellValue = cellVal.toString();
                }
                if (cellVal instanceof Float) {
                    cellValue = this.numberformat.format(cellVal);
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(cellValue));
            }
            ++rowId;
        }
        return wb;
    }

    public <T> HSSFWorkbook object2Excel(List<T> list, String propertyKeys, String propertyShowKeys) throws Exception {
        return this.object2Excel(list, propertyKeys, propertyShowKeys, new DefaultPropertyExtractor());
    }

    private String[] Tokenizer2StringArray(String sourceStr, String strDot) {
        StringTokenizer st = new StringTokenizer(sourceStr, strDot);
        int size = st.countTokens();
        String[] strArray = new String[size];
        for (int i = 0; i < size; ++i) {
            strArray[i] = st.nextToken();
        }
        return strArray;
    }
}

